/*
 * generated by Xtext
 */
package org.eclipse.xtext.ui.codetemplates.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;
import org.eclipse.xtext.ui.codetemplates.services.CodetemplatesGrammarAccess;
import org.eclipse.xtext.ui.codetemplates.templates.Codetemplate;
import org.eclipse.xtext.ui.codetemplates.templates.Codetemplates;
import org.eclipse.xtext.ui.codetemplates.templates.Dollar;
import org.eclipse.xtext.ui.codetemplates.templates.Literal;
import org.eclipse.xtext.ui.codetemplates.templates.TemplateBody;
import org.eclipse.xtext.ui.codetemplates.templates.TemplatesPackage;
import org.eclipse.xtext.ui.codetemplates.templates.Variable;

@SuppressWarnings("all")
public class CodetemplatesSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private CodetemplatesGrammarAccess grammarAccess;
	
	@Override
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == TemplatesPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case TemplatesPackage.CODETEMPLATE:
				sequence_Codetemplate(context, (Codetemplate) semanticObject); 
				return; 
			case TemplatesPackage.CODETEMPLATES:
				sequence_Codetemplates(context, (Codetemplates) semanticObject); 
				return; 
			case TemplatesPackage.DOLLAR:
				sequence_Dollar(context, (Dollar) semanticObject); 
				return; 
			case TemplatesPackage.LITERAL:
				sequence_Literal(context, (Literal) semanticObject); 
				return; 
			case TemplatesPackage.TEMPLATE_BODY:
				sequence_TemplateBody(context, (TemplateBody) semanticObject); 
				return; 
			case TemplatesPackage.VARIABLE:
				sequence_Variable(context, (Variable) semanticObject); 
				return; 
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (name=ValidID id=ID description=STRING (context=[AbstractRule|ValidID] | keywordContext=STRING) body=TemplateBodyWithQuotes)
	 */
	protected void sequence_Codetemplate(EObject context, Codetemplate semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (language=[Grammar|FQN] templates+=Codetemplate*)
	 */
	protected void sequence_Codetemplates(EObject context, Codetemplates semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (escaped?='$$'?)
	 */
	protected void sequence_Dollar(EObject context, Dollar semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     value=LiteralValue
	 */
	protected void sequence_Literal(EObject context, Literal semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, TemplatesPackage.Literals.LITERAL__VALUE) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, TemplatesPackage.Literals.LITERAL__VALUE));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getLiteralAccess().getValueLiteralValueParserRuleCall_0(), semanticObject.getValue());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (parts+=Literal? (parts+=VariableOrDollar parts+=Literal?)*)
	 */
	protected void sequence_TemplateBody(EObject context, TemplateBody semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         name=ValidID | 
	 *         (name=ValidID? type=ValidID (expectingParameters?='(' ((parameters+=STRING | parameters+=FQN) (parameters+=STRING | parameters+=FQN)*)?)?)
	 *     )
	 */
	protected void sequence_Variable(EObject context, Variable semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
