/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.generator.trace;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IEditorPart;
import org.eclipse.xtext.generator.IDerivedResourceMarkers;
import org.eclipse.xtext.ui.generator.trace.FileOpener;
import org.eclipse.xtext.ui.generator.trace.OppositeFileOpenerContributor;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Pair;

public class DerivedResourceMarkerBasedOpenerContributor
extends OppositeFileOpenerContributor {
    private static final Logger LOG = Logger.getLogger(DerivedResourceMarkerBasedOpenerContributor.class);
    @Inject
    private IDerivedResourceMarkers derivedResourceMarkers;
    @Inject
    private IStorage2UriMapper storage2UriMapper;

    @Override
    public boolean collectGeneratedFileOpeners(IEditorPart editor, IAcceptor<FileOpener> acceptor) {
        IStorage storage = this.getStorage(editor);
        if (storage != null) {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            URI uri = URI.createPlatformResourceURI((String)storage.getFullPath().toString(), (boolean)true);
            try {
                List resources = this.derivedResourceMarkers.findDerivedResources((IContainer)root, uri.toString());
                for (IFile file : resources) {
                    acceptor.accept((Object)this.createOpener((IStorage)file));
                }
                return true;
            }
            catch (CoreException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean collectSourceFileOpeners(IEditorPart editor, IAcceptor<FileOpener> acceptor) {
        IStorage storage = this.getStorage(editor);
        if (storage instanceof IResource) {
            IResource resource = (IResource)storage;
            try {
                HashSet uris = Sets.newHashSet();
                IMarker[] markers = this.derivedResourceMarkers.findDerivedResourceMarkers(resource);
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    String source = this.derivedResourceMarkers.getSource(marker);
                    if (source != null) {
                        uris.add(URI.createURI((String)source));
                    }
                    ++n2;
                }
                for (URI uri : uris) {
                    for (Pair pair : this.storage2UriMapper.getStorages(uri)) {
                        acceptor.accept((Object)this.createOpener((IStorage)pair.getFirst()));
                    }
                }
                return true;
            }
            catch (CoreException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }
}

