/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hover;

import com.google.inject.Inject;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.ui.editor.hover.AbstractHover;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public abstract class AbstractEObjectHover
extends AbstractHover
implements IEObjectHover {
    @Inject
    private EObjectAtOffsetHelper eObjectAtOffsetHelper;
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    @Override
    public IRegion getHoverRegion(ITextViewer textViewer, final int offset) {
        IXtextDocument xtextDocument = XtextDocumentUtil.get(textViewer);
        if (xtextDocument == null) {
            return null;
        }
        try {
            return (IRegion)xtextDocument.tryReadOnly((IUnitOfWork)new IUnitOfWork<IRegion, XtextResource>(){

                public IRegion exec(XtextResource state) throws Exception {
                    Pair<EObject, IRegion> element = AbstractEObjectHover.this.getXtextElementAt(state, offset);
                    if (element != null) {
                        return (IRegion)element.getSecond();
                    }
                    return null;
                }
            });
        }
        catch (OperationCanceledException e) {
            return null;
        }
        catch (OperationCanceledError e) {
            return null;
        }
    }

    public Object getHoverInfo2(final ITextViewer textViewer, final IRegion hoverRegion) {
        if (hoverRegion == null) {
            return null;
        }
        IXtextDocument xtextDocument = XtextDocumentUtil.get(textViewer);
        if (xtextDocument == null) {
            return null;
        }
        try {
            return xtextDocument.tryReadOnly((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

                public Object exec(XtextResource state) throws Exception {
                    Pair<EObject, IRegion> element = AbstractEObjectHover.this.getXtextElementAt(state, hoverRegion.getOffset());
                    if (element != null && element.getFirst() != null) {
                        return AbstractEObjectHover.this.getHoverInfo((EObject)element.getFirst(), textViewer, hoverRegion);
                    }
                    return null;
                }
            });
        }
        catch (OperationCanceledException e) {
            return null;
        }
        catch (OperationCanceledError e) {
            return null;
        }
    }

    @Override
    public abstract Object getHoverInfo(EObject var1, ITextViewer var2, IRegion var3);

    protected Pair<EObject, IRegion> getXtextElementAt(XtextResource resource, IRegion hoverRegion) {
        return this.getXtextElementAt(resource, hoverRegion.getOffset());
    }

    protected Pair<EObject, IRegion> getXtextElementAt(XtextResource resource, int offset) {
        EObject crossLinkedEObject = this.eObjectAtOffsetHelper.resolveCrossReferencedElementAt(resource, offset);
        if (crossLinkedEObject != null) {
            IParseResult parseResult;
            if (!crossLinkedEObject.eIsProxy() && (parseResult = resource.getParseResult()) != null) {
                ILeafNode leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)offset);
                if (leafNode != null && leafNode.isHidden() && leafNode.getOffset() == offset) {
                    leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)parseResult.getRootNode(), (int)(offset - 1));
                }
                if (leafNode != null) {
                    ITextRegion leafRegion = leafNode.getTextRegion();
                    return Tuples.create((Object)crossLinkedEObject, (Object)new Region(leafRegion.getOffset(), leafRegion.getLength()));
                }
            }
        } else {
            ITextRegion region;
            Region region2;
            EObject o = this.eObjectAtOffsetHelper.resolveElementAt(resource, offset);
            if (o != null && TextUtilities.overlaps((IRegion)(region2 = new Region((region = this.locationInFileProvider.getSignificantTextRegion(o)).getOffset(), region.getLength())), (IRegion)new Region(offset, 0))) {
                return Tuples.create((Object)o, (Object)region2);
            }
        }
        return null;
    }
}

