/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.folding;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;

public class DefaultFoldedPosition
extends FoldedPosition {
    static final int UNSET = -1;
    private final int contentStart;
    private final int contentLength;
    private boolean initiallyFolded;

    public DefaultFoldedPosition(int offset, int length, int contentStart, int contentLength) {
        this(offset, length, contentStart, contentLength, false);
    }

    @Deprecated
    public DefaultFoldedPosition(int offset, int length, int contentStart, int contentLength, boolean initiallyFolded) {
        super(offset, length);
        this.contentStart = contentStart;
        this.contentLength = contentLength;
        this.initiallyFolded = initiallyFolded;
    }

    public IRegion[] computeProjectionRegions(IDocument document) throws BadLocationException {
        Region preRegion;
        if (this.contentStart == -1) {
            int line = document.getLineOfOffset(this.offset);
            int offset = document.getLineOffset(line + 1);
            int length = this.length - (offset - this.offset);
            if (length > 0) {
                return new IRegion[]{new Region(offset, length)};
            }
            return null;
        }
        int firstLine = document.getLineOfOffset(this.offset);
        int captionLine = document.getLineOfOffset(this.offset + this.contentStart);
        int captionEndLine = document.getLineOfOffset(this.offset + this.contentStart + this.contentLength);
        int lastLine = document.getLineOfOffset(this.offset + this.length) - 1;
        if (firstLine < captionLine) {
            int preOffset = document.getLineOffset(firstLine);
            IRegion preEndLineInfo = document.getLineInformation(captionLine);
            int preEnd = preEndLineInfo.getOffset();
            preRegion = new Region(preOffset, preEnd - preOffset);
        } else {
            preRegion = null;
        }
        if (captionEndLine < lastLine) {
            int postOffset = document.getLineOffset(captionLine + 1);
            Region postRegion = new Region(postOffset, this.offset + this.length - postOffset);
            if (preRegion == null) {
                return new IRegion[]{postRegion};
            }
            return new IRegion[]{preRegion, postRegion};
        }
        if (preRegion != null) {
            return new IRegion[]{preRegion};
        }
        return null;
    }

    public int computeCaptionOffset(IDocument document) throws BadLocationException {
        if (this.contentStart == -1) {
            return 0;
        }
        return this.contentStart;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.contentLength;
        result = 31 * result + this.contentStart;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DefaultFoldedPosition other = (DefaultFoldedPosition)((Object)obj);
        if (this.contentLength != other.contentLength) {
            return false;
        }
        return this.contentStart == other.contentStart;
    }

    public boolean isInitiallyFolded() {
        return this.initiallyFolded;
    }

    public void setInitiallyFolded(boolean initiallyFolded) {
        this.initiallyFolded = initiallyFolded;
    }
}

