/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.parser.antlr.splitting;

import com.google.common.collect.Maps;
import com.google.inject.Injector;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.ConditionSimplifier;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.SimpleExpressionsStandaloneSetup;
import org.eclipse.xtext.xtext.generator.parser.antlr.splitting.simpleExpressions.IfCondition;

public class UnorderedGroupsSplitter {
    private static final String INTERNAL_ENCODING = "UTF-8";
    private final String content;
    private ConditionSimplifier simplifier;

    public UnorderedGroupsSplitter(String content) {
        this.content = content;
        this.simplifier = new ConditionSimplifier();
    }

    public String transform() {
        Injector injector = new SimpleExpressionsStandaloneSetup().createInjectorAndDoEMFRegistration();
        IResourceFactory resourceFactory = (IResourceFactory)injector.getInstance(IResourceFactory.class);
        return this.transformContent(resourceFactory);
    }

    protected String transformContent(IResourceFactory resourceFactory) {
        String string;
        BufferedReader reader = new BufferedReader(new StringReader(this.content));
        try {
            StringWriter writer = new StringWriter(this.content.length());
            PrintWriter printer = new PrintWriter(writer);
            String line = reader.readLine();
            while (line != null) {
                line = this.transfromLine(line, resourceFactory);
                printer.println(line);
                line = reader.readLine();
            }
            printer.close();
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return string;
    }

    public String transfromLine(String line, IResourceFactory resourceFactory) throws IOException {
        if (this.shouldSimplify(line)) {
            int braceIdx = line.indexOf(123);
            String lineAsInput = line.substring(0, braceIdx + 1);
            Resource resource = this.getResource(lineAsInput, resourceFactory);
            IfCondition condition = (IfCondition)resource.getContents().get(0);
            this.simplifier.simplify(condition);
            String fixedLine = this.saveResource(resource);
            fixedLine = this.addPostfix(line, braceIdx, fixedLine);
            return fixedLine;
        }
        return line;
    }

    private String addPostfix(String line, int braceIdx, String fixedLine) {
        if (braceIdx != line.length() - 1) {
            fixedLine = String.valueOf(fixedLine) + line.substring(braceIdx + 1);
        }
        return fixedLine;
    }

    protected String saveResource(Resource resource) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.content.length());
        try {
            String result;
            HashMap options = Maps.newHashMap();
            options.put(XtextResource.OPTION_ENCODING, INTERNAL_ENCODING);
            SaveOptions.defaultOptions().addTo((Map)options);
            resource.save((OutputStream)out, (Map)options);
            String string = result = new String(out.toByteArray(), INTERNAL_ENCODING);
            return string;
        }
        finally {
            out.close();
        }
    }

    protected Resource getResource(String input, IResourceFactory resourceFactory) throws IOException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input.getBytes(INTERNAL_ENCODING));
        try {
            Resource resource = resourceFactory.createResource(URI.createURI((String)"dummy.simpleexpressions"));
            resource.load((InputStream)inputStream, Collections.singletonMap(XtextResource.OPTION_ENCODING, INTERNAL_ENCODING));
            if (!resource.getErrors().isEmpty()) {
                throw new RuntimeException(String.valueOf(input) + " - " + resource.getErrors().toString());
            }
            ((InputStream)inputStream).close();
            Resource resource2 = resource;
            return resource2;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public boolean shouldSimplify(String line) {
        String trimmedLine = line.trim();
        return (trimmedLine.startsWith("else if") || trimmedLine.startsWith("if")) && (trimmedLine.contains("getUnorderedGroupHelper()") || !trimmedLine.contains("state.backtracking>0") && trimmedLine.contains("p_") && !trimmedLine.contains("boolean p_"));
    }
}

