/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.analysis;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.grammaranalysis.impl.CfgAdapter;
import org.eclipse.xtext.serializer.analysis.IContextPDAProvider;
import org.eclipse.xtext.serializer.analysis.ISerState;
import org.eclipse.xtext.serializer.analysis.SerializerPDA;
import org.eclipse.xtext.util.formallang.Cfg;
import org.eclipse.xtext.util.formallang.FollowerFunction;
import org.eclipse.xtext.util.formallang.FollowerFunctionImpl;
import org.eclipse.xtext.util.formallang.Pda;
import org.eclipse.xtext.util.formallang.PdaFactory;
import org.eclipse.xtext.util.formallang.PdaUtil;
import org.eclipse.xtext.util.formallang.Production;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class ContextPDAProvider
implements IContextPDAProvider {
    protected Map<EObject, Pda<ISerState, RuleCall>> cache = Maps.newHashMap();
    @Inject
    protected PdaUtil pdaUtil;

    protected Pda<ISerState, RuleCall> createPDA(Action action) {
        SerializerActionCfg cfg = new SerializerActionCfg(action);
        SerializerActionFollowerFunction ff = new SerializerActionFollowerFunction((Production<AbstractElement, AbstractElement>)cfg, action);
        SerializerPDA.SerializerPDAElementFactory fact = new SerializerPDA.SerializerPDAElementFactory();
        Pda actionpda = this.pdaUtil.create((Cfg)cfg, (FollowerFunction)ff, (PdaFactory)fact);
        SerializerPDA.SerializerPDAGetToken getToken = new SerializerPDA.SerializerPDAGetToken();
        Pda expandedpda = this.pdaUtil.expand(actionpda, (Function)new ExpandRuleCalls(), (Function)getToken, (PdaFactory)fact);
        Pda filteredpda = this.pdaUtil.filterOrphans(expandedpda, (PdaFactory)new SerializerPDA.SerializerPDACloneFactory());
        return filteredpda;
    }

    protected Pda<ISerState, RuleCall> createPDA(EObject context, Pda<ISerState, RuleCall> result) {
        if (context instanceof ParserRule) {
            return this.createPDA((ParserRule)context);
        }
        if (context instanceof Action) {
            return this.createPDA((Action)context);
        }
        throw new IllegalStateException("illegal context");
    }

    protected Pda<ISerState, RuleCall> createPDA(ParserRule rule) {
        SerializerParserRuleCfg cfg = new SerializerParserRuleCfg(rule);
        SerializerParserRuleFollowerFunction ff = new SerializerParserRuleFollowerFunction((Production<AbstractElement, AbstractElement>)cfg, rule);
        Pda pda = this.pdaUtil.create((Cfg)cfg, (FollowerFunction)ff, (PdaFactory)new SerializerPDA.SerializerPDAElementFactory());
        return this.pdaUtil.filterOrphans(pda, (PdaFactory)new SerializerPDA.SerializerPDACloneFactory());
    }

    @Override
    public Pda<ISerState, RuleCall> getContextPDA(EObject context) {
        Pda<ISerState, RuleCall> result = this.cache.get(context);
        if (result == null) {
            result = this.createPDA(context, result);
            this.cache.put(context, result);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ExpandRuleCalls
    implements Function<ISerState, Pda<ISerState, RuleCall>> {
        protected ExpandRuleCalls() {
        }

        public Pda<ISerState, RuleCall> apply(ISerState input) {
            if (GrammarUtil.isUnassignedParserRuleCall(input.getGrammarElement())) {
                return ContextPDAProvider.this.getContextPDA(((RuleCall)input.getGrammarElement()).getRule());
            }
            return null;
        }
    }

    protected static class SerializerActionCfg
    extends CfgAdapter {
        protected Action context;

        public SerializerActionCfg(Action context) {
            super(GrammarUtil.getGrammar(context));
            this.context = context;
        }

        public AbstractElement getCall(AbstractElement ele) {
            return null;
        }

        public AbstractElement getRoot() {
            return GrammarUtil.containingRule(this.context).getAlternatives();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SerializerActionFollowerFunction
    extends FollowerFunctionImpl<AbstractElement, AbstractElement> {
        protected Action actionCtx;

        public SerializerActionFollowerFunction(Production<AbstractElement, AbstractElement> production, Action context) {
            super(production);
            this.actionCtx = context;
        }

        public Iterable<AbstractElement> getFollowers(AbstractElement element) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (AbstractElement ele : super.getFollowers((Object)element)) {
                if (ele == null) continue;
                if (this.actionCtx == ele) {
                    result.add(null);
                    continue;
                }
                if (GrammarUtil.isAssignedAction(ele)) continue;
                result.add(ele);
            }
            return result;
        }

        public Iterable<AbstractElement> getStarts(AbstractElement root) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (Action act : GrammarUtil.containedActions(root)) {
                if (act.getFeature() == null) continue;
                result.add(act);
            }
            for (AbstractElement ele : super.getStarts((Object)root)) {
                if (ele == null) continue;
                if (this.actionCtx == ele) {
                    result.add(null);
                    continue;
                }
                if (GrammarUtil.isAssignedAction(ele)) continue;
                result.add(ele);
            }
            return result;
        }
    }

    protected static class SerializerParserRuleCfg
    extends CfgAdapter {
        protected ParserRule context;

        public SerializerParserRuleCfg(ParserRule context) {
            super(GrammarUtil.getGrammar(context));
            this.context = context;
        }

        public AbstractElement getCall(AbstractElement ele) {
            if (ele instanceof RuleCall && !GrammarUtil.isAssigned(ele) && ((RuleCall)ele).getRule().getType().getClassifier() instanceof EClass) {
                return ((RuleCall)ele).getRule().getAlternatives();
            }
            return null;
        }

        public AbstractElement getRoot() {
            return this.context.getAlternatives();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SerializerParserRuleFollowerFunction
    extends FollowerFunctionImpl<AbstractElement, AbstractElement> {
        protected ParserRule ruleCtx;

        public SerializerParserRuleFollowerFunction(Production<AbstractElement, AbstractElement> production, ParserRule context) {
            super(production);
            this.ruleCtx = context;
        }

        public Iterable<AbstractElement> getFollowers(AbstractElement element) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (AbstractElement ele : super.getFollowers((Object)element)) {
                if (ele == null) {
                    result.add(null);
                    continue;
                }
                if (GrammarUtil.isAssignedAction(ele)) continue;
                result.add(ele);
            }
            return result;
        }

        public Iterable<AbstractElement> getStarts(AbstractElement root) {
            LinkedHashSet result = Sets.newLinkedHashSet();
            for (Action act : GrammarUtil.containedActions(root)) {
                if (act.getFeature() == null) continue;
                result.add(act);
            }
            for (AbstractElement ele : super.getStarts((Object)root)) {
                if (ele == null) {
                    result.add(null);
                    continue;
                }
                if (GrammarUtil.isAssignedAction(ele)) continue;
                result.add(ele);
            }
            return result;
        }
    }
}

