/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist;

import com.google.inject.Inject;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionListenerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistantExtension2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.xtext.ui.editor.contentassist.XtextContentAssistProcessor;

public class RepeatedContentAssistProcessor
extends XtextContentAssistProcessor
implements ICompletionListener,
ICompletionListenerExtension {
    @Inject(optional=true)
    private IWorkbench workbench;
    private IContentAssistantExtension2 currentAssistant;

    public ModeAware getModeAwareProposalProvider() {
        return (ModeAware)((Object)super.getContentProposalProvider());
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ModeAware proposalProvider = this.getModeAwareProposalProvider();
        int i = 0;
        while (i++ < 1000) {
            ICompletionProposal[] result;
            proposalProvider.nextMode();
            if (this.currentAssistant != null) {
                this.currentAssistant.setStatusMessage(this.getStatusMessage());
            }
            if ((result = super.computeCompletionProposals(viewer, offset)) != null && result.length > 0) {
                return result;
            }
            if (!proposalProvider.isLastMode()) continue;
            return new ICompletionProposal[0];
        }
        throw new IllegalStateException("#isLastMode did not return true for 1000 times");
    }

    protected String getStatusMessage() {
        String binding = "<binding>";
        if (this.workbench != null) {
            IBindingService bindingService = (IBindingService)this.workbench.getAdapter(IBindingService.class);
            binding = bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        }
        String category = this.getModeAwareProposalProvider().getNextCategory();
        return String.valueOf(binding) + " to show " + category;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
        this.getModeAwareProposalProvider().reset();
        this.currentAssistant = (IContentAssistantExtension2)event.assistant;
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.getModeAwareProposalProvider().reset();
        this.currentAssistant = null;
    }

    public void assistSessionRestarted(ContentAssistEvent event) {
        this.getModeAwareProposalProvider().reset();
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public static interface ModeAware {
        public void reset();

        public void nextMode();

        public boolean isLastMode();

        public String getNextCategory();
    }
}

