/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XDoWhileExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XInstanceOfExpression;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XWhileExpression;
import org.eclipse.xtext.xbase.compiler.FeatureCallCompiler;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.typing.Closures;

public class XbaseCompiler
extends FeatureCallCompiler {
    @Inject
    IEarlyExitComputer earlyExitComputer;
    @Inject
    private Closures closures;
    @Inject
    private TypeArgumentContextProvider ctxProvider;

    protected void _toJavaStatement(XBlockExpression expr, IAppendable b, boolean isReferenced) {
        if (expr.getExpressions().isEmpty()) {
            return;
        }
        if (expr.getExpressions().size() == 1) {
            this.internalToJavaStatement((XExpression)expr.getExpressions().get(0), b, isReferenced);
            return;
        }
        if (isReferenced) {
            this.declareSyntheticVariable(expr, b);
        }
        b.append("\n{").increaseIndentation();
        EList<XExpression> expressions = expr.getExpressions();
        int i = 0;
        while (i < expressions.size()) {
            XExpression ex = (XExpression)expressions.get(i);
            if (i < expressions.size() - 1) {
                this.internalToJavaStatement(ex, b, false);
            } else {
                this.internalToJavaStatement(ex, b, isReferenced);
                if (isReferenced) {
                    b.append("\n").append(this.getVarName(expr, b)).append(" = (");
                    this.internalToConvertedExpression(ex, b, null);
                    b.append(");");
                }
            }
            ++i;
        }
        b.decreaseIndentation().append("\n}");
    }

    protected void _toJavaExpression(XBlockExpression expr, IAppendable b) {
        if (expr.getExpressions().isEmpty()) {
            b.append("null");
            return;
        }
        if (expr.getExpressions().size() == 1) {
            this.internalToConvertedExpression((XExpression)expr.getExpressions().get(0), b, null);
            return;
        }
        b.append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XTryCatchFinallyExpression expr, IAppendable b, boolean isReferenced) {
        if (isReferenced && !this.isPrimitiveVoid(expr)) {
            this.declareSyntheticVariable(expr, b);
        }
        b.append("\ntry {").increaseIndentation();
        boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getExpression());
        this.internalToJavaStatement(expr.getExpression(), b, canBeReferenced);
        if (canBeReferenced) {
            b.append("\n").append(this.getVarName(expr, b)).append(" = ");
            this.internalToConvertedExpression(expr.getExpression(), b, null);
            b.append(";");
        }
        b.decreaseIndentation().append("\n}");
        this.appendCatchAndFinally(expr, b, isReferenced);
    }

    protected void appendCatchAndFinally(XTryCatchFinallyExpression expr, IAppendable b, boolean isReferenced) {
        XExpression finallyExp;
        EList<XCatchClause> catchClauses = expr.getCatchClauses();
        if (!catchClauses.isEmpty()) {
            String variable = b.declareSyntheticVariable(Tuples.pair((Object)expr, (Object)"_catchedThrowable"), "_t");
            b.append(" catch (final Throwable ").append(variable).append(") ");
            b.append("{").increaseIndentation();
            b.append("\n");
            Iterator iterator = catchClauses.iterator();
            while (iterator.hasNext()) {
                XCatchClause catchClause = (XCatchClause)iterator.next();
                JvmTypeReference type = catchClause.getDeclaredParam().getParameterType();
                String name = b.declareVariable(catchClause.getDeclaredParam(), catchClause.getDeclaredParam().getName());
                b.append("if (").append(variable).append(" instanceof ");
                b.append(type.getType());
                b.append(") ").append("{");
                b.increaseIndentation();
                b.append("\nfinal ");
                this.serialize(type, expr, b);
                b.append(" ").append(name).append(" = (");
                this.serialize(type, expr, b);
                b.append(")").append(variable).append(";");
                boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(catchClause.getExpression());
                this.internalToJavaStatement(catchClause.getExpression(), b, canBeReferenced);
                if (canBeReferenced) {
                    b.append("\n").append(this.getVarName(expr, b)).append(" = ");
                    this.internalToConvertedExpression(catchClause.getExpression(), b, null);
                    b.append(";");
                }
                b.decreaseIndentation();
                b.append("\n}");
                if (!iterator.hasNext()) continue;
                b.append(" else ");
            }
            b.append(" else {");
            b.increaseIndentation();
            b.append("\nthrow ");
            b.append(this.getTypeReferences().findDeclaredType(Exceptions.class, (EObject)expr));
            b.append(".sneakyThrow(");
            b.append(variable);
            b.append(");");
            b.decreaseIndentation();
            b.append("\n}");
            b.decreaseIndentation();
            b.append("\n}");
        }
        if ((finallyExp = expr.getFinallyExpression()) != null) {
            b.append(" finally {").increaseIndentation();
            this.internalToJavaStatement(finallyExp, b, false);
            b.decreaseIndentation().append("\n}");
        }
    }

    protected void _toJavaExpression(XTryCatchFinallyExpression expr, IAppendable b) {
        b.append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XThrowExpression expr, IAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getExpression(), b, true);
        b.append("\nthrow ");
        this.internalToJavaExpression(expr.getExpression(), b);
        b.append(";");
    }

    protected void _toJavaExpression(XThrowExpression expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaExpression(XInstanceOfExpression expr, IAppendable b) {
        b.append("(");
        this.internalToJavaExpression(expr.getExpression(), b);
        b.append(" instanceof ").append(expr.getType()).append(")");
    }

    protected void _toJavaStatement(XInstanceOfExpression expr, IAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getExpression(), b, true);
    }

    protected void _toJavaExpression(XVariableDeclaration expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaStatement(XVariableDeclaration varDeclaration, IAppendable b, boolean isReferenced) {
        if (varDeclaration.getRight() != null) {
            this.internalToJavaStatement(varDeclaration.getRight(), b, true);
        }
        b.append("\n");
        if (!varDeclaration.isWriteable()) {
            b.append("final ");
        }
        JvmTypeReference type = null;
        type = varDeclaration.getType() != null ? varDeclaration.getType() : this.getTypeProvider().getType(varDeclaration.getRight());
        this.serialize(type, varDeclaration, b);
        b.append(" ");
        b.append(b.declareVariable(varDeclaration, varDeclaration.getName()));
        b.append(" = ");
        if (varDeclaration.getRight() != null) {
            this.internalToConvertedExpression(varDeclaration.getRight(), b, type);
        } else if (this.getPrimitives().isPrimitive(type)) {
            Primitives.Primitive primitiveKind = this.getPrimitives().primitiveKind((JvmPrimitiveType)type.getType());
            switch (primitiveKind) {
                case Boolean: {
                    b.append("false");
                    break;
                }
                default: {
                    b.append("0");
                    break;
                }
            }
        } else {
            b.append("null");
        }
        b.append(";");
    }

    protected void _toJavaExpression(XWhileExpression expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaStatement(XWhileExpression expr, IAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        String varName = b.declareSyntheticVariable(expr, "_while");
        b.append("\nboolean ").append(varName).append(" = ");
        this.internalToJavaExpression(expr.getPredicate(), b);
        b.append(";");
        b.append("\nwhile (");
        b.append(varName);
        b.append(") {").increaseIndentation();
        b.openPseudoScope();
        this.internalToJavaStatement(expr.getBody(), b, false);
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        b.append("\n");
        if (!this.earlyExitComputer.isEarlyExit(expr.getBody())) {
            b.append(varName).append(" = ");
            this.internalToJavaExpression(expr.getPredicate(), b);
            b.append(";");
        }
        b.closeScope();
        b.decreaseIndentation().append("\n}");
    }

    protected void _toJavaExpression(XDoWhileExpression expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaStatement(XDoWhileExpression expr, IAppendable b, boolean isReferenced) {
        String variable = b.declareSyntheticVariable(expr, "_dowhile");
        b.append("\nboolean ").append(variable).append(" = false;");
        b.append("\ndo {").increaseIndentation();
        this.internalToJavaStatement(expr.getBody(), b, false);
        this.internalToJavaStatement(expr.getPredicate(), b, true);
        b.append("\n");
        if (!this.earlyExitComputer.isEarlyExit(expr.getBody())) {
            b.append(variable).append(" = ");
            this.internalToJavaExpression(expr.getPredicate(), b);
            b.append(";");
        }
        b.decreaseIndentation().append("\n} while(");
        b.append(variable);
        b.append(");");
    }

    protected void _toJavaExpression(XForLoopExpression expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaStatement(XForLoopExpression expr, IAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getForExpression(), b, true);
        b.append("\nfor (final ");
        JvmTypeReference paramType = this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)expr.getDeclaredParam());
        this.serialize(paramType, expr, b);
        b.append(" ");
        String varName = b.declareVariable(expr.getDeclaredParam(), expr.getDeclaredParam().getName());
        b.append(varName);
        b.append(" : ");
        this.internalToJavaExpression(expr.getForExpression(), b);
        b.append(") {").increaseIndentation();
        this.internalToJavaStatement(expr.getEachExpression(), b, false);
        b.decreaseIndentation().append("\n}");
    }

    protected void _toJavaStatement(final XConstructorCall expr, final IAppendable b, boolean isReferenced) {
        for (XExpression arg : expr.getArguments()) {
            this.internalToJavaStatement(arg, b, true);
        }
        Later later = new Later(){

            public void exec() {
                b.append("new ");
                JvmTypeReference producedType = XbaseCompiler.this.getTypeProvider().getType(expr);
                XbaseCompiler.this.serialize(producedType, expr, b, false, false, true, false);
                b.append("(");
                XbaseCompiler.this.appendArguments((List<? extends XExpression>)expr.getArguments(), (JvmExecutable)expr.getConstructor(), expr, b, false);
                b.append(")");
            }
        };
        if (isReferenced) {
            this.declareSyntheticVariable(expr, b, later);
        } else {
            b.append("\n");
            later.exec();
            b.append(";");
        }
    }

    protected void _toJavaExpression(XConstructorCall expr, IAppendable b) {
        String varName = this.getVarName(expr, b);
        b.append(varName);
    }

    protected void _toJavaStatement(XReturnExpression expr, IAppendable b, boolean isReferenced) {
        if (expr.getExpression() != null) {
            this.internalToJavaStatement(expr.getExpression(), b, true);
            b.append("\nreturn ");
            this.internalToJavaExpression(expr.getExpression(), b);
            b.append(";");
        } else {
            b.append("\nreturn;");
        }
    }

    protected void _toJavaExpression(XReturnExpression expr, IAppendable b) {
        b.append("null");
    }

    protected void _toJavaExpression(XCastedExpression expr, IAppendable b) {
        b.append("((");
        this.serialize(expr.getType(), expr, b);
        b.append(") ");
        this.internalToConvertedExpression(expr.getTarget(), b, expr.getType());
        b.append(")");
    }

    protected void _toJavaStatement(XCastedExpression expr, IAppendable b, boolean isReferenced) {
        this.internalToJavaStatement(expr.getTarget(), b, isReferenced);
    }

    protected void _toJavaStatement(XIfExpression expr, IAppendable b, boolean isReferenced) {
        if (isReferenced) {
            this.declareSyntheticVariable(expr, b);
        }
        this.internalToJavaStatement(expr.getIf(), b, true);
        b.append("\nif (");
        this.internalToJavaExpression(expr.getIf(), b);
        b.append(") {").increaseIndentation();
        boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getThen());
        this.internalToJavaStatement(expr.getThen(), b, canBeReferenced);
        if (canBeReferenced) {
            b.append("\n");
            b.append(this.getVarName(expr, b));
            b.append(" = ");
            this.internalToConvertedExpression(expr.getThen(), b, null);
            b.append(";");
        }
        b.decreaseIndentation().append("\n}");
        if (expr.getElse() != null) {
            b.append(" else {").increaseIndentation();
            boolean canElseBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getElse());
            this.internalToJavaStatement(expr.getElse(), b, canElseBeReferenced);
            if (canElseBeReferenced) {
                b.append("\n");
                b.append(this.getVarName(expr, b));
                b.append(" = ");
                this.internalToConvertedExpression(expr.getElse(), b, null);
                b.append(";");
            }
            b.decreaseIndentation().append("\n}");
        }
    }

    protected void _toJavaExpression(XIfExpression expr, IAppendable b) {
        b.append(this.getVarName(expr, b));
    }

    protected void _toJavaStatement(XSwitchExpression expr, IAppendable b, boolean isReferenced) {
        JvmTypeReference type = this.getTypeProvider().getType(expr);
        String switchResultName = b.declareSyntheticVariable(Tuples.pair((Object)expr, (Object)"result"), "_switchResult");
        if (isReferenced) {
            b.append("\n");
            this.serialize(type, expr, b);
            b.append(" ").append(switchResultName).append(" = ");
            b.append(this.getDefaultValueLiteral(expr));
            b.append(";");
        }
        this.internalToJavaStatement(expr.getSwitch(), b, true);
        String variableName = null;
        if (expr.getLocalVarName() == null && expr.getSwitch() instanceof XFeatureCall) {
            variableName = b.getName(((XFeatureCall)expr.getSwitch()).getFeature());
        }
        if (variableName == null) {
            String name = this.getNameProvider().getSimpleName(expr);
            name = name != null ? this.makeJavaIdentifier(name) : "__valOfSwitchOver";
            JvmTypeReference typeReference = this.getTypeProvider().getType(expr.getSwitch());
            b.append("\nfinal ");
            this.serialize(typeReference, expr, b);
            b.append(" ");
            variableName = b.declareSyntheticVariable(expr, name);
            b.append(variableName);
            b.append(" = ");
            this.internalToJavaExpression(expr.getSwitch(), b);
            b.append(";");
        }
        b.append("\nboolean ");
        String matchedVariable = b.declareSyntheticVariable(Tuples.pair((Object)expr, (Object)"matches"), "matched");
        b.append(matchedVariable).append(" = false;");
        for (XCasePart casePart : expr.getCases()) {
            b.append("\nif (!").append(matchedVariable).append(") {");
            b.increaseIndentation();
            if (casePart.getTypeGuard() != null) {
                b.append("\nif (");
                b.append(variableName);
                b.append(" instanceof ");
                b.append(casePart.getTypeGuard().getType());
                b.append(") {");
                b.increaseIndentation();
                XSwitchExpression switchOver = expr.getSwitch() instanceof XFeatureCall ? ((XFeatureCall)expr.getSwitch()).getFeature() : expr;
                b.openPseudoScope();
                String proposedName = "_" + Strings.toFirstLower((String)casePart.getTypeGuard().getType().getSimpleName());
                String castedVariableName = b.declareSyntheticVariable(switchOver, proposedName);
                b.append("\nfinal ");
                this.serialize(casePart.getTypeGuard(), expr, b);
                b.append(" ");
                b.append(castedVariableName);
                b.append(" = (");
                this.serialize(casePart.getTypeGuard(), expr, b);
                b.append(")");
                b.append(variableName);
                b.append(";");
            }
            if (casePart.getCase() != null) {
                this.internalToJavaStatement(casePart.getCase(), b, true);
                b.append("\nif (");
                JvmTypeReference convertedType = this.getTypeProvider().getType(casePart.getCase());
                if (this.getTypeReferences().is(convertedType, Boolean.TYPE) || this.getTypeReferences().is(convertedType, Boolean.class)) {
                    this.internalToJavaExpression(casePart.getCase(), b);
                } else {
                    JvmTypeReference typeRef = this.getTypeReferences().getTypeForName(ObjectExtensions.class, (EObject)expr, new JvmTypeReference[0]);
                    this.serialize(typeRef, (EObject)casePart, b);
                    b.append(".operator_equals(").append(variableName).append(",");
                    this.internalToJavaExpression(casePart.getCase(), b);
                    b.append(")");
                }
                b.append(") {");
                b.increaseIndentation();
            }
            b.append("\n").append(matchedVariable).append("=true;");
            boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(casePart.getThen());
            this.internalToJavaStatement(casePart.getThen(), b, canBeReferenced);
            if (canBeReferenced) {
                b.append("\n").append(switchResultName).append(" = ");
                this.internalToConvertedExpression(casePart.getThen(), b, null);
                b.append(";");
            }
            if (casePart.getCase() != null) {
                b.decreaseIndentation().append("\n}");
            }
            if (casePart.getTypeGuard() != null) {
                b.decreaseIndentation().append("\n}");
                b.closeScope();
            }
            b.decreaseIndentation();
            b.append("\n}");
        }
        if (expr.getDefault() != null) {
            b.append("\nif (!").append(matchedVariable).append(") {");
            b.increaseIndentation();
            boolean canBeReferenced = isReferenced && !this.isPrimitiveVoid(expr.getDefault());
            this.internalToJavaStatement(expr.getDefault(), b, canBeReferenced);
            if (canBeReferenced) {
                b.append("\n").append(switchResultName).append(" = ");
                this.internalToConvertedExpression(expr.getDefault(), b, null);
                b.append(";");
            }
            b.decreaseIndentation();
            b.append("\n}");
        }
    }

    protected void _toJavaExpression(XSwitchExpression expr, IAppendable b) {
        b.append(this.getVarName(Tuples.pair((Object)expr, (Object)"result"), b));
    }

    protected void _toJavaStatement(XClosure closure, IAppendable b, boolean isReferenced) {
        if (!isReferenced) {
            throw new IllegalArgumentException("a closure definition does not cause any side-effects");
        }
        JvmTypeReference type = this.getTypeProvider().getType(closure);
        ITypeArgumentContext context = this.ctxProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.ReceiverRequest(type));
        b.append("\n").append("final ");
        this.serialize(type, closure, b);
        b.append(" ");
        String variableName = b.declareSyntheticVariable(closure, "_function");
        b.append(variableName).append(" = ");
        b.append("new ");
        this.serialize(type, closure, b, false, false, true, false);
        b.append("() {");
        b.increaseIndentation().increaseIndentation();
        try {
            String proposedName;
            b.openScope();
            JvmOperation operation = this.closures.findImplementingOperation(type, closure.eResource());
            JvmTypeReference returnType = context.resolve(operation.getReturnType());
            b.append("\npublic ");
            this.serialize(returnType, closure, b, false, false, true, true);
            b.append(" ").append(operation.getSimpleName());
            b.append("(");
            EList<JvmFormalParameter> closureParams = closure.getFormalParameters();
            EList operationParams = operation.getParameters();
            int i = 0;
            while (i < closureParams.size()) {
                JvmFormalParameter closureParam = (JvmFormalParameter)closureParams.get(i);
                JvmFormalParameter operationParam = (JvmFormalParameter)operationParams.get(i);
                JvmTypeReference parameterType = context.resolve(operationParam.getParameterType());
                b.append("final ");
                this.serialize(parameterType, closure, b, false, false, true, true);
                b.append(" ");
                String name = b.declareVariable(closureParam, closureParam.getName());
                b.append(name);
                if (i != closureParams.size() - 1) {
                    b.append(", ");
                }
                ++i;
            }
            b.append(") {");
            b.increaseIndentation();
            Object element = b.getObject("this");
            if (element instanceof JvmType && b.getObject(proposedName = String.valueOf(((JvmType)element).getSimpleName()) + ".this") == null) {
                b.declareSyntheticVariable(element, proposedName);
                Object superElement = b.getObject("super");
                if (superElement instanceof JvmType) {
                    b.declareSyntheticVariable(superElement, String.valueOf(((JvmType)element).getSimpleName()) + ".super");
                }
            }
            this.compile(closure.getExpression(), b, operation.getReturnType(), Sets.newHashSet((Iterable)operation.getExceptions()));
        }
        finally {
            b.closeScope();
        }
        b.decreaseIndentation();
        b.append("\n}");
        b.decreaseIndentation().append("\n};").decreaseIndentation();
    }

    protected void _toJavaExpression(XClosure call, IAppendable b) {
        b.append(this.getVarName(call, b));
    }
}

