/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.style.impl;

import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.helper.GradientHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.style.CSSShapeStyle;
import org.w3c.dom.css.CSSValue;

public class CSSShapeStyleDelegate
implements CSSShapeStyle {
    private ShapeStyle shapeStyle;
    private ExtendedCSSEngine engine;

    public CSSShapeStyleDelegate(ShapeStyle shapeStyle, ExtendedCSSEngine engine) {
        this.shapeStyle = shapeStyle;
        this.engine = engine;
    }

    @Override
    public int getCSSFontColor() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "fontColor");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_FontColor().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, "GMFColor", null);
    }

    @Override
    public String getCSSFontName() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "fontName");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_FontName().getDefaultValue();
            return (String)defaultValue;
        }
        return (String)this.engine.convert(cssValue, String.class, null);
    }

    @Override
    public int getCSSFontHeight() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "fontHeight");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_FontHeight().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    @Override
    public boolean isCSSBold() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "bold");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_Bold().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }

    @Override
    public boolean isCSSItalic() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "italic");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_Italic().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }

    @Override
    public boolean isCSSUnderline() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "underline");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_Underline().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }

    @Override
    public boolean isCSSStrikeThrough() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "strikeThrough");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().getDefaultValue();
            return (Boolean)defaultValue;
        }
        return (Boolean)this.engine.convert(cssValue, Boolean.class, null);
    }

    @Override
    public String getCSSDescription() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "description");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getDescriptionStyle_Description().getDefaultValue();
            return (String)defaultValue;
        }
        return (String)this.engine.convert(cssValue, String.class, null);
    }

    @Override
    public int getCSSFillColor() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "fillColor");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFillStyle_FillColor().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, "GMFColor", null);
    }

    @Override
    public int getCSSTransparency() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "transparency");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getFillStyle_Transparency().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    @Override
    public GradientData getCSSGradient() {
        return GradientHelper.computeGradient(this.engine, this.shapeStyle);
    }

    @Override
    public int getCSSLineColor() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "lineColor");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getLineStyle_LineColor().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, "GMFColor", null);
    }

    @Override
    public int getCSSLineWidth() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "lineWidth");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getLineStyle_LineWidth().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }

    @Override
    public int getCSSRoundedBendpointsRadius() {
        CSSValue cssValue = this.engine.retrievePropertyValue(this.shapeStyle, "roundedBendpointsRadius");
        if (cssValue == null) {
            Object defaultValue = NotationPackage.eINSTANCE.getRoundedCornersStyle_RoundedBendpointsRadius().getDefaultValue();
            return (Integer)defaultValue;
        }
        return (Integer)this.engine.convert(cssValue, Integer.class, null);
    }
}

