/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.search.utils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.papyrus.views.search.results.AbstractResultEntry;
import org.eclipse.papyrus.views.search.scope.ScopeEntry;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class MatchUtils {
    public static Set<AbstractResultEntry> getMatches(AbstractTextSearchResult searchResult, Class<?> type, boolean checkFiltered) {
        HashSet<AbstractResultEntry> results = new HashSet<AbstractResultEntry>();
        List<Object> elementList = Arrays.asList(searchResult.getElements());
        for (Object element : elementList) {
            Match[] matchArray = searchResult.getMatches(element);
            int n = matchArray.length;
            int n2 = 0;
            while (n2 < n) {
                Match match = matchArray[n2];
                if (match instanceof AbstractResultEntry && match.getElement() instanceof ScopeEntry) {
                    boolean toAdd = false;
                    if (checkFiltered) {
                        if (!match.isFiltered()) {
                            toAdd = true;
                        }
                    } else {
                        toAdd = true;
                    }
                    if (toAdd && type.isAssignableFrom(((AbstractResultEntry)match).elementToCheckFilterFor().getClass())) {
                        results.add((AbstractResultEntry)match);
                    }
                }
                ++n2;
            }
        }
        return results;
    }

    public static Set<AbstractResultEntry> getMatches(AbstractTextSearchResult searchResult, boolean checkFiltered) {
        return MatchUtils.getMatches(searchResult, Object.class, checkFiltered);
    }
}

