/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.bridge.transform;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.gmf.internal.bridge.genmodel.QVTDiagramGenModelTransformer;
import org.eclipse.papyrus.gmf.internal.bridge.transform.ITransformToGenModelOperation;
import org.eclipse.papyrus.gmf.internal.bridge.transform.Messages;
import org.eclipse.papyrus.gmf.internal.bridge.transform.TransformOptions;
import org.eclipse.papyrus.gmf.internal.bridge.transform.TransformToGenModelWizard;
import org.eclipse.papyrus.gmf.internal.bridge.ui.Plugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

class ViewmapProducerWizardPage
extends WizardPage {
    private boolean myInitingControls;
    private Button generateRCPButton;
    private Button useMapModeButton;
    private Button useRuntimeFiguresButton;
    private Button useModeledViewmapButton;
    private Text templatesPathText;
    private Text qvtoFileControl;
    private Text preReconcileTranfsormText;
    private Text postReconcileTransformText;
    private Button radioDGMT;
    private Button radioQVT;
    private Button radioCustomQVT;
    private Button preReconcileTransformBtn;
    private Button postReconcileTransformBtn;
    private ExpandItem myTemplatePathItem;
    private ExpandItem myTransformsItem;
    private Composite composite;

    protected ViewmapProducerWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.TransformToGenModelWizard_title_options);
        this.setDescription(Messages.TransformToGenModelWizard_descr_options);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.createControls(this.composite);
        this.setControl((Control)this.composite);
        Dialog.applyDialogFont((Control)this.composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initControls();
            this.validatePage();
        }
    }

    private void createControls(Composite result) {
        this.useMapModeButton = new Button(result, 32);
        this.useMapModeButton.setText(Messages.ViewmapProducerWizardPage_btn_mapmode);
        this.useMapModeButton.setLayoutData((Object)new GridData(36));
        this.useRuntimeFiguresButton = new Button(result, 32);
        this.useRuntimeFiguresButton.setText(Messages.ViewmapProducerWizardPage_btn_runtime);
        this.useRuntimeFiguresButton.setLayoutData((Object)new GridData(36));
        this.generateRCPButton = new Button(result, 32);
        this.generateRCPButton.setText(Messages.ViewmapProducerWizardPage_btn_rcp);
        this.generateRCPButton.setLayoutData((Object)new GridData(36));
        this.useModeledViewmapButton = new Button(this.composite, 32);
        this.useModeledViewmapButton.setText(Messages.ViewmapProducerWizardPage_btnUseModeledViewmap_text);
        this.useModeledViewmapButton.setLayoutData((Object)new GridData(36));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (ViewmapProducerWizardPage.this.generateRCPButton == e.widget) {
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setGenerateRCP(ViewmapProducerWizardPage.this.generateRCPButton.getSelection());
                } else if (ViewmapProducerWizardPage.this.useMapModeButton == e.widget) {
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setUseMapMode(ViewmapProducerWizardPage.this.useMapModeButton.getSelection());
                } else if (ViewmapProducerWizardPage.this.useRuntimeFiguresButton == e.widget) {
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setUseRuntimeFigures(ViewmapProducerWizardPage.this.useRuntimeFiguresButton.getSelection());
                } else if (ViewmapProducerWizardPage.this.useModeledViewmapButton == e.widget) {
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setInTransformationCodeGen(!ViewmapProducerWizardPage.this.useModeledViewmapButton.getSelection());
                }
                ViewmapProducerWizardPage.this.validatePage();
            }
        };
        this.useMapModeButton.addSelectionListener(selectionListener);
        this.useRuntimeFiguresButton.addSelectionListener(selectionListener);
        this.generateRCPButton.addSelectionListener(selectionListener);
        this.useModeledViewmapButton.addSelectionListener(selectionListener);
        this.createAdvancedControls(result);
        Composite glue = new Composite(result, 0);
        glue.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void createAdvancedControls(Composite result) {
        Group parent = new Group(result, 16);
        parent.setText("Provisional");
        parent.setLayout((Layout)new FillLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        ExpandBar c = new ExpandBar((Composite)parent, 0);
        c.setBackground(parent.getBackground());
        this.templatesPathText = new Text((Composite)c, 2052);
        Listener modifyListener = new Listener(){

            public void handleEvent(Event event) {
                ViewmapProducerWizardPage.this.validatePage();
            }
        };
        this.templatesPathText.addListener(24, modifyListener);
        this.myTemplatePathItem = new ExpandItem(c, 0, 0);
        this.myTemplatePathItem.setText("GMFGraph dynamic templates");
        this.myTemplatePathItem.setHeight(this.templatesPathText.computeSize((int)-1, (int)-1).y);
        this.myTemplatePathItem.setControl((Control)this.templatesPathText);
        Composite map2genControls = new Composite((Composite)c, 0);
        map2genControls.setLayout((Layout)new FillLayout(512));
        this.radioDGMT = new Button(map2genControls, 16);
        this.radioDGMT.setText("Use Java transformation");
        this.radioQVT = new Button(map2genControls, 16);
        this.radioQVT.setText("Use QVTO transformation");
        this.radioCustomQVT = new Button(map2genControls, 16);
        this.radioCustomQVT.setText("Use custom QVTO transformation:");
        this.qvtoFileControl = new Text(map2genControls, 2052);
        this.radioDGMT.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == ViewmapProducerWizardPage.this.radioDGMT) {
                    ViewmapProducerWizardPage.this.qvtoFileControl.setEditable(false);
                    ViewmapProducerWizardPage.this.qvtoFileControl.setEnabled(false);
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setTransformation(null);
                }
            }
        });
        this.radioQVT.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == ViewmapProducerWizardPage.this.radioQVT) {
                    ViewmapProducerWizardPage.this.qvtoFileControl.setEditable(false);
                    ViewmapProducerWizardPage.this.qvtoFileControl.setEnabled(false);
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setTransformation(QVTDiagramGenModelTransformer.getDefaultTransformation());
                }
            }
        });
        this.radioCustomQVT.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == ViewmapProducerWizardPage.this.radioCustomQVT) {
                    ViewmapProducerWizardPage.this.qvtoFileControl.setEditable(true);
                    ViewmapProducerWizardPage.this.qvtoFileControl.setEnabled(true);
                    if (ViewmapProducerWizardPage.this.qvtoFileControl.getText() != null) {
                        ViewmapProducerWizardPage.this.getOperation().getOptions().setTransformation(ViewmapProducerWizardPage.this.checkTextFieldURI(ViewmapProducerWizardPage.this.qvtoFileControl));
                    }
                }
            }
        });
        this.qvtoFileControl.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == ViewmapProducerWizardPage.this.qvtoFileControl && ViewmapProducerWizardPage.this.radioCustomQVT.getSelection() && ViewmapProducerWizardPage.this.qvtoFileControl.getText() != null) {
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setTransformation(ViewmapProducerWizardPage.this.checkTextFieldURI(ViewmapProducerWizardPage.this.qvtoFileControl));
                }
            }
        });
        this.preReconcileTransformBtn = new Button(map2genControls, 32);
        this.preReconcileTransformBtn.setText("Extra in-place gmfgen transformation before a reconcile step");
        this.preReconcileTranfsormText = new Text(map2genControls, 2052);
        this.postReconcileTransformBtn = new Button(map2genControls, 32);
        this.postReconcileTransformBtn.setText("Extra in-place gmfgen transformation after a reconcile step");
        this.postReconcileTransformText = new Text(map2genControls, 2052);
        this.preReconcileTransformBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    ViewmapProducerWizardPage.this.preReconcileTranfsormText.setEditable(true);
                    ViewmapProducerWizardPage.this.preReconcileTranfsormText.setEnabled(true);
                    if (ViewmapProducerWizardPage.this.preReconcileTranfsormText.getText() != null) {
                        ViewmapProducerWizardPage.this.getOperation().getOptions().setPreReconcileTransform(ViewmapProducerWizardPage.this.checkTextFieldURI(ViewmapProducerWizardPage.this.preReconcileTranfsormText));
                    }
                } else {
                    ViewmapProducerWizardPage.this.preReconcileTranfsormText.setEditable(true);
                    ViewmapProducerWizardPage.this.preReconcileTranfsormText.setEnabled(true);
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setPreReconcileTransform(null);
                }
            }
        });
        this.preReconcileTranfsormText.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (ViewmapProducerWizardPage.this.preReconcileTransformBtn.getSelection() && ViewmapProducerWizardPage.this.preReconcileTranfsormText.getText() != null) {
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setPreReconcileTransform(ViewmapProducerWizardPage.this.checkTextFieldURI(ViewmapProducerWizardPage.this.preReconcileTranfsormText));
                }
            }
        });
        this.postReconcileTransformBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    ViewmapProducerWizardPage.this.postReconcileTransformText.setEditable(true);
                    ViewmapProducerWizardPage.this.postReconcileTransformText.setEnabled(true);
                    if (ViewmapProducerWizardPage.this.postReconcileTransformText.getText() != null) {
                        ViewmapProducerWizardPage.this.getOperation().getOptions().setPostReconcileTransform(ViewmapProducerWizardPage.this.checkTextFieldURI(ViewmapProducerWizardPage.this.postReconcileTransformText));
                    }
                } else {
                    ViewmapProducerWizardPage.this.postReconcileTransformText.setEditable(true);
                    ViewmapProducerWizardPage.this.postReconcileTransformText.setEnabled(true);
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setPostReconcileTransform(null);
                }
            }
        });
        this.postReconcileTransformText.addListener(2, new Listener(){

            public void handleEvent(Event event) {
                if (ViewmapProducerWizardPage.this.postReconcileTransformBtn.getSelection() && ViewmapProducerWizardPage.this.postReconcileTransformText.getText() != null) {
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setPostReconcileTransform(ViewmapProducerWizardPage.this.checkTextFieldURI(ViewmapProducerWizardPage.this.postReconcileTransformText));
                }
            }
        });
        this.preReconcileTranfsormText.addListener(24, modifyListener);
        this.postReconcileTransformText.addListener(24, modifyListener);
        String hint = "Transformation should take single inout parameter of GMFGen model type, e.g.\n\nmodeltype GMFGEN uses gmfgen('http://www.eclipse.org/papyrus/gmf/2020/GenModel');\n\ntransformation %s(inout gmfgenModel : GMFGEN);\n\n main() {...}";
        this.preReconcileTranfsormText.setToolTipText(String.format(hint, "PreReconcile"));
        this.postReconcileTransformText.setToolTipText(String.format(hint, "PostReconcile"));
        this.myTransformsItem = new ExpandItem(c, 0, 1);
        this.myTransformsItem.setText("Map to Gen transformation");
        this.myTransformsItem.setHeight(map2genControls.computeSize((int)-1, (int)-1).y);
        this.myTransformsItem.setControl((Control)map2genControls);
    }

    void validatePage() {
        if (this.myInitingControls) {
            return;
        }
        this.setStatus(Status.OK_STATUS);
        boolean hasLite = TransformOptions.checkLiteOptionPresent();
        if (hasLite && !this.useRuntimeFiguresButton.getSelection() && this.useMapModeButton.getSelection()) {
            this.setStatus(Plugin.createInfo(Messages.ViewmapProducerWizardPage_i_not_recommended));
        }
        TransformOptions options = this.getOperation().getOptions();
        options.setFigureTemplatesPath(this.checkTextFieldURI(this.templatesPathText));
    }

    private URL checkTextFieldURI(Text widget) {
        if (widget == null) {
            return null;
        }
        if (!widget.isEnabled()) {
            return null;
        }
        if (widget.getText().trim().length() > 0) {
            try {
                return new URL(ViewmapProducerWizardPage.guessAndResolvePathURL(widget.getText().trim()));
            }
            catch (MalformedURLException ex) {
                this.setStatus(Plugin.createWarning(ex.getMessage()));
            }
        }
        return null;
    }

    private void initControls() {
        this.myInitingControls = true;
        try {
            TransformOptions options = this.getOperation().getOptions();
            this.generateRCPButton.setSelection(options.getGenerateRCP());
            this.useRuntimeFiguresButton.setSelection(options.getUseRuntimeFigures());
            this.useMapModeButton.setSelection(options.getUseMapMode());
            this.useModeledViewmapButton.setSelection(!options.getUseInTransformationCodeGen());
            if (options.getFigureTemplatesPath() != null) {
                this.templatesPathText.setText(options.getFigureTemplatesPath().toString());
                this.myTemplatePathItem.setExpanded(true);
            }
            this.radioDGMT.setSelection(options.getMainTransformation() == null);
            this.radioQVT.setSelection(!this.radioDGMT.getSelection() && !this.radioCustomQVT.getSelection());
            this.radioCustomQVT.setSelection(!this.radioDGMT.getSelection() && !this.radioQVT.getSelection());
            this.qvtoFileControl.setEnabled(this.radioCustomQVT.getSelection());
            this.qvtoFileControl.setText(options.getMainTransformation() != null ? options.getMainTransformation().toString() : QVTDiagramGenModelTransformer.getDefaultTransformation().toString());
            this.preReconcileTransformBtn.setSelection(options.getPreReconcileTransform() != null);
            this.preReconcileTranfsormText.setEnabled(this.preReconcileTransformBtn.getSelection());
            this.preReconcileTranfsormText.setText(options.getPreReconcileTransform() != null ? options.getPreReconcileTransform().toString() : "");
            this.postReconcileTransformBtn.setSelection(options.getPostReconcileTransform() != null);
            this.postReconcileTransformText.setEnabled(this.postReconcileTransformBtn.getSelection());
            this.postReconcileTransformText.setText(options.getPostReconcileTransform() != null ? options.getPostReconcileTransform().toString() : "");
            if (this.radioQVT.getSelection() || this.radioCustomQVT.getSelection() || this.preReconcileTransformBtn.getSelection() || this.postReconcileTransformBtn.getSelection()) {
                this.myTransformsItem.setExpanded(true);
            }
        }
        finally {
            this.myInitingControls = false;
        }
    }

    private ITransformToGenModelOperation getOperation() {
        return ((TransformToGenModelWizard)this.getWizard()).getTransformOperation();
    }

    private void setStatus(IStatus s) {
        if (s.isOK()) {
            this.setMessage(null);
            this.setPageComplete(true);
        } else {
            this.setMessage(s.getMessage(), 1);
            this.setPageComplete(s.getSeverity() < 2);
        }
    }

    private static String guessAndResolvePathURL(String path) {
        assert (path != null);
        if (path.indexOf(58) == -1) {
            try {
                URI templatesURI = URI.createPlatformResourceURI((String)path, (boolean)true);
                return templatesURI.toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return path;
    }
}

