/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.extension.nebula.richtext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.ContextualDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.MarkupProcessor;
import org.eclipse.nebula.widgets.nattable.extension.nebula.richtext.RegexMarkupValue;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.util.ObjectUtils;

public class MarkupDisplayConverter
extends ContextualDisplayConverter {
    protected IDisplayConverter wrappedConverter;
    protected Map<String, MarkupProcessor> markups = new LinkedHashMap<String, MarkupProcessor>();
    protected List<MarkupValueForLabels> markupsForLabels = new ArrayList<MarkupValueForLabels>();

    public MarkupDisplayConverter() {
        this((IDisplayConverter)new DefaultDisplayConverter());
    }

    public MarkupDisplayConverter(IDisplayConverter wrappedConverter) {
        this.wrappedConverter = wrappedConverter;
    }

    public Object canonicalToDisplayValue(ILayerCell cell, IConfigRegistry configRegistry, Object canonicalValue) {
        Object wrappedConverterResult = this.wrappedConverter.canonicalToDisplayValue(cell, configRegistry, canonicalValue);
        String result = null;
        if (wrappedConverterResult != null) {
            result = wrappedConverterResult.toString();
            result = StringEscapeUtils.escapeHtml4((String)String.valueOf(result));
            for (MarkupProcessor markup : this.getMarkupProcessors(cell)) {
                result = markup.applyMarkup(result);
            }
        }
        return result;
    }

    public Object displayToCanonicalValue(ILayerCell cell, IConfigRegistry configRegistry, Object displayValue) {
        if (displayValue != null) {
            String result = displayValue.toString();
            ArrayList<MarkupProcessor> mc = new ArrayList<MarkupProcessor>(this.getMarkupProcessors(cell));
            Collections.reverse(mc);
            for (MarkupProcessor markup : mc) {
                result = markup.removeMarkup(result);
            }
            result = StringEscapeUtils.unescapeHtml4((String)String.valueOf(result));
            return this.wrappedConverter.displayToCanonicalValue(cell, configRegistry, (Object)result);
        }
        return this.wrappedConverter.displayToCanonicalValue(cell, configRegistry, displayValue);
    }

    protected List<MarkupProcessor> getMarkupProcessors(ILayerCell cell) {
        ArrayList<MarkupProcessor> mc = new ArrayList<MarkupProcessor>(this.markups.values());
        mc.addAll(this.markupsForLabels.stream().filter(m -> cell.getConfigLabels().hasAllLabels(m.labels)).map(m -> m.processor).collect(Collectors.toList()));
        return mc;
    }

    public void registerMarkup(String value, String markupPrefix, String markupSuffix) {
        MarkupValue markupValue = new MarkupValue();
        markupValue.original = value;
        markupValue.markup = String.valueOf(markupPrefix) + value + markupSuffix;
        this.registerMarkup(value, markupValue);
    }

    public void registerMarkupForLabel(String value, String markupPrefix, String markupSuffix, String ... labels) {
        MarkupValue markupValue = new MarkupValue();
        markupValue.original = value;
        markupValue.markup = String.valueOf(markupPrefix) + value + markupSuffix;
        this.registerMarkupForLabel((MarkupProcessor)markupValue, labels);
    }

    public void registerMarkupForLabel(String value, String markupPrefix, String markupSuffix, List<String> labels) {
        MarkupValue markupValue = new MarkupValue();
        markupValue.original = value;
        markupValue.markup = String.valueOf(markupPrefix) + value + markupSuffix;
        this.registerMarkupForLabel((MarkupProcessor)markupValue, labels);
    }

    public void registerRegexMarkup(String value, String markupPrefix, String markupSuffix) {
        RegexMarkupValue markup = new RegexMarkupValue(value, markupPrefix, markupSuffix);
        this.registerMarkup(value, markup);
    }

    public void registerRegexMarkupForLabel(String value, String markupPrefix, String markupSuffix, String ... labels) {
        RegexMarkupValue markup = new RegexMarkupValue(value, markupPrefix, markupSuffix);
        this.registerMarkupForLabel((MarkupProcessor)markup, labels);
    }

    public void registerRegexMarkupForLabel(String value, String markupPrefix, String markupSuffix, List<String> labels) {
        RegexMarkupValue markup = new RegexMarkupValue(value, markupPrefix, markupSuffix);
        this.registerMarkupForLabel((MarkupProcessor)markup, labels);
    }

    public void registerMarkup(String id, MarkupProcessor processor) {
        this.markups.put(id, processor);
    }

    public void unregisterMarkup(String value) {
        this.markups.remove(value);
    }

    public void registerMarkupForLabel(MarkupProcessor processor, String ... labels) {
        this.registerMarkupForLabel(processor, Arrays.asList(labels));
    }

    public void registerMarkupForLabel(MarkupProcessor processor, List<String> labels) {
        MarkupValueForLabels markupValue = new MarkupValueForLabels();
        markupValue.labels = labels;
        markupValue.processor = processor;
        this.markupsForLabels.add(markupValue);
    }

    public void unregisterMarkupForLabel(String ... labels) {
        Iterator<MarkupValueForLabels> it = this.markupsForLabels.iterator();
        while (it.hasNext()) {
            MarkupValueForLabels markupValue = it.next();
            if (!ObjectUtils.collectionsEqual(markupValue.labels, Arrays.asList(labels))) continue;
            it.remove();
        }
    }

    public void clearMarkups() {
        this.markups.clear();
        this.markupsForLabels.clear();
    }

    protected class MarkupValue
    implements MarkupProcessor {
        String original;
        String markup;

        protected MarkupValue() {
        }

        @Override
        public String applyMarkup(String input) {
            return input.replaceAll(this.original, this.markup);
        }

        @Override
        public String removeMarkup(String input) {
            return input.replaceAll(this.markup, this.original);
        }
    }

    protected class MarkupValueForLabels {
        List<String> labels;
        MarkupProcessor processor;

        protected MarkupValueForLabels() {
        }
    }
}

