/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.migration.commands;

import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.stereotype.StereotypeLocationEnum;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.commands.StereotypePropertiesMigrationCommand;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;

public class StereotypeCommentPropertiesMigrationCommand
extends StereotypePropertiesMigrationCommand {
    private boolean deleteOldComment;

    public StereotypeCommentPropertiesMigrationCommand(String label, View content, boolean deleteOldComment) {
        super(label, content);
        this.deleteOldComment = deleteOldComment;
    }

    @Override
    protected void updateStereotypePropertyDisplay(View view, String propertyList, Enum<?> location) {
        Node newComment;
        if (StereotypeLocationEnum.IN_COMMENT.equals(location) && (newComment = helper.getStereotypeComment(view)) != null) {
            super.updateStereotypePropertyDisplay((View)newComment, propertyList, location);
            this.setConstraint(view, newComment);
            Edge stereotypeCommentLink = this.getStereotypeCommentLink(view, newComment);
            if (stereotypeCommentLink != null) {
                this.setBendpointsAnchors(view, stereotypeCommentLink);
            }
        }
        if (this.deleteOldComment) {
            this.deleteOldComment(view);
        }
    }

    private Edge getStereotypeCommentLink(View view, Node newComment) {
        EList targetEdges = newComment.getTargetEdges();
        for (Edge edge : targetEdges) {
            if (!helper.isStereotypeCommentLink(edge) || !edge.getSource().equals(view)) continue;
            return edge;
        }
        return null;
    }

    private void setConstraint(View view, Node newComment) {
        View oldComment = migrationHelper.getOldStereotypeComment(view);
        if (oldComment instanceof Node) {
            newComment.setLayoutConstraint(((Node)oldComment).getLayoutConstraint());
        }
    }

    private void setBendpointsAnchors(View view, Edge edge) {
        Edge oldStereotypeLinkComment = migrationHelper.getOldStereotypeLinkComment(view);
        if (oldStereotypeLinkComment != null) {
            edge.setBendpoints(oldStereotypeLinkComment.getBendpoints());
            edge.setSourceAnchor(oldStereotypeLinkComment.getSourceAnchor());
            edge.setTargetAnchor(oldStereotypeLinkComment.getTargetAnchor());
        }
    }

    private void deleteOldComment(View hostView) {
        Edge oldLink;
        View oldComment = migrationHelper.getOldStereotypeComment(hostView);
        if (oldComment != null) {
            DeleteCommand deleteComment = new DeleteCommand(oldComment);
            CommandUtil.executeUnsafeCommand((ICommand)deleteComment, (Object)hostView);
        }
        if ((oldLink = migrationHelper.getOldStereotypeLinkComment(hostView)) != null) {
            DeleteCommand deleteLink = new DeleteCommand((View)oldLink);
            CommandUtil.executeUnsafeCommand((ICommand)deleteLink, (Object)hostView);
        }
    }
}

