/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.collections.api.map.primitive.IntIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntIntMap;
import org.eclipse.collections.impl.factory.primitive.IntIntMaps;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.SpanningLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.command.ConfigureScalingCommand;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;
import org.eclipse.nebula.widgets.nattable.reorder.event.ColumnReorderEvent;

public abstract class AbstractColumnHideShowLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private MutableIntIntMap cachedVisibleColumnIndexPositionMapping;
    private MutableIntIntMap cachedVisibleColumnPositionIndexMapping;
    private MutableIntIntMap cachedHiddenColumnIndexPositionMapping;
    private MutableIntIntMap startXCache = IntIntMaps.mutable.empty();

    public AbstractColumnHideShowLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
    }

    @Override
    protected IUniqueIndexLayer getUnderlyingLayer() {
        return (IUniqueIndexLayer)super.getUnderlyingLayer();
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (this.hasHiddenColumns() && event instanceof ColumnReorderEvent) {
            ColumnReorderEvent reorderEvent = (ColumnReorderEvent)event;
            int[] fromPositions = reorderEvent.getBeforeFromColumnIndexes().stream().mapToInt(Integer::intValue).map(this::getColumnPositionByIndex).filter(pos -> pos >= 0).toArray();
            List<Range> fromRanges = PositionUtil.getRanges(fromPositions);
            int pos2 = -1;
            if (!this.isColumnIndexHidden(reorderEvent.getBeforeToColumnIndex())) {
                pos2 = this.getColumnPositionByIndex(reorderEvent.getBeforeToColumnIndex());
            } else {
                int i = 1;
                while (pos2 < 0) {
                    int next = reorderEvent.getBeforeToColumnPosition() + i;
                    if (next >= this.underlyingLayer.getColumnCount()) break;
                    pos2 = this.underlyingToLocalColumnPosition(this.underlyingLayer, next);
                    ++i;
                }
                if (pos2 >= 0) {
                    reorderEvent.setBeforeToColumnIndex(this.getColumnIndexByPosition(pos2));
                }
            }
            if (pos2 >= 0) {
                reorderEvent.setConvertedBeforePositions(this, fromRanges, pos2);
            }
        }
        if (event instanceof IStructuralChangeEvent) {
            IStructuralChangeEvent structuralChangeEvent = (IStructuralChangeEvent)event;
            if (structuralChangeEvent.isHorizontalStructureChanged()) {
                this.invalidateCache();
            }
        } else if (event instanceof VisualRefreshEvent) {
            this.startXCache = IntIntMaps.mutable.empty();
        }
        super.handleLayerEvent(event);
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ConfigureScalingCommand) {
            this.invalidateCache();
        }
        return super.doCommand(command);
    }

    @Override
    public int getColumnCount() {
        if (!this.hasHiddenColumns()) {
            return super.getColumnCount();
        }
        return this.getCachedVisibleColumnIndexPositionMapping().size();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        if (columnPosition < 0 || columnPosition >= this.getColumnCount()) {
            return -1;
        }
        if (!this.hasHiddenColumns()) {
            return super.getColumnIndexByPosition(columnPosition);
        }
        return this.getCachedVisibleColumnPositionIndexMapping().getIfAbsent(columnPosition, -1);
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        if (!this.hasHiddenColumns()) {
            return this.getUnderlyingLayer().getColumnPositionByIndex(columnIndex);
        }
        return this.getCachedVisibleColumnIndexPositionMapping().getIfAbsent(columnIndex, -1);
    }

    public Collection<Integer> getColumnPositionsByIndexes(Collection<Integer> columnIndexes) {
        HashSet<Integer> columnPositions = new HashSet<Integer>();
        for (int columnIndex : columnIndexes) {
            columnPositions.add(this.getColumnPositionByIndex(columnIndex));
        }
        return columnPositions;
    }

    public int[] getColumnPositionsByIndexes(int ... columnIndexes) {
        return columnIndexes != null && columnIndexes.length > 0 ? Arrays.stream(columnIndexes).map(this::getColumnPositionByIndex).toArray() : new int[]{};
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        if (localColumnPosition < 0 || localColumnPosition >= this.getColumnCount()) {
            return -1;
        }
        if (!this.hasHiddenColumns()) {
            return localColumnPosition;
        }
        int columnIndex = this.getColumnIndexByPosition(localColumnPosition);
        return this.getUnderlyingLayer().getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (!this.hasHiddenColumns()) {
            return underlyingColumnPosition;
        }
        int columnIndex = this.getUnderlyingLayer().getColumnIndexByPosition(underlyingColumnPosition);
        int columnPosition = this.getColumnPositionByIndex(columnIndex);
        if (columnPosition >= 0) {
            return columnPosition;
        }
        return this.getCachedHiddenColumnIndexPositionMapping().getIfAbsent(columnIndex, -1);
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        ArrayList<Range> localColumnPositionRanges = new ArrayList<Range>(underlyingColumnPositionRanges.size());
        for (Range underlyingColumnPositionRange : underlyingColumnPositionRanges) {
            int startColumnPosition = this.getAdjustedUnderlyingToLocalStartPosition(sourceUnderlyingLayer, underlyingColumnPositionRange.start, underlyingColumnPositionRange.end);
            int endColumnPosition = this.getAdjustedUnderlyingToLocalEndPosition(sourceUnderlyingLayer, underlyingColumnPositionRange.end, underlyingColumnPositionRange.start);
            if (startColumnPosition <= -1) continue;
            localColumnPositionRanges.add(new Range(startColumnPosition, endColumnPosition));
        }
        return localColumnPositionRanges;
    }

    private int getAdjustedUnderlyingToLocalStartPosition(ILayer sourceUnderlyingLayer, int startUnderlyingPosition, int endUnderlyingPosition) {
        int localStartColumnPosition = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, startUnderlyingPosition);
        int offset = 0;
        while (localStartColumnPosition < 0 && startUnderlyingPosition + offset < endUnderlyingPosition) {
            localStartColumnPosition = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, startUnderlyingPosition + offset++);
        }
        return localStartColumnPosition;
    }

    private int getAdjustedUnderlyingToLocalEndPosition(ILayer sourceUnderlyingLayer, int endUnderlyingPosition, int startUnderlyingPosition) {
        int localEndColumnPosition = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, endUnderlyingPosition - 1);
        int offset = 0;
        while (localEndColumnPosition < 0 && endUnderlyingPosition - offset > startUnderlyingPosition) {
            localEndColumnPosition = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, endUnderlyingPosition - offset++);
        }
        return localEndColumnPosition + 1;
    }

    @Override
    public int getWidth() {
        if (this.getColumnCount() == 0) {
            return 0;
        }
        int lastColumnPosition = this.getColumnCount() - 1;
        return this.getStartXOfColumnPosition(lastColumnPosition) + this.getColumnWidthByPosition(lastColumnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return LayerUtil.getColumnPositionByX(this, x);
    }

    @Override
    public int getStartXOfColumnPosition(int localColumnPosition) {
        int cachedStartX = this.startXCache.getIfAbsent(localColumnPosition, -1);
        if (cachedStartX != -1) {
            return cachedStartX;
        }
        IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
        int underlyingPosition = this.localToUnderlyingColumnPosition(localColumnPosition);
        if (underlyingPosition < 0) {
            return -1;
        }
        int underlyingStartX = underlyingLayer.getStartXOfColumnPosition(underlyingPosition);
        if (underlyingStartX < 0) {
            return -1;
        }
        int[] nArray = this.getHiddenColumnIndexesArray();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int hiddenIndex = nArray[n2];
            int hiddenPosition = underlyingLayer.getColumnPositionByIndex(hiddenIndex);
            if (hiddenPosition >= 0 && hiddenPosition <= underlyingPosition) {
                underlyingStartX -= underlyingLayer.getColumnWidthByPosition(hiddenPosition);
            }
            ++n2;
        }
        this.startXCache.put(localColumnPosition, underlyingStartX);
        return underlyingStartX;
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.getUnderlyingLayer().getRowPositionByIndex(rowIndex);
    }

    public abstract boolean isColumnIndexHidden(int var1);

    public abstract Collection<Integer> getHiddenColumnIndexes();

    public abstract int[] getHiddenColumnIndexesArray();

    public abstract boolean hasHiddenColumns();

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        ILayerCell cell = super.getCellByPosition(columnPosition, rowPosition);
        if (cell != null && cell.isSpannedCell()) {
            int underlyingColumnPosition = this.localToUnderlyingColumnPosition(columnPosition);
            int underlyingRowPosition = this.localToUnderlyingRowPosition(rowPosition);
            ILayerCell underlyingCell = this.underlyingLayer.getCellByPosition(underlyingColumnPosition, underlyingRowPosition);
            boolean columnSpanUpdated = false;
            int columnSpan = underlyingCell.getColumnSpan();
            int column = 0;
            while (column < underlyingCell.getColumnSpan()) {
                int columnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingCell.getOriginColumnPosition() + column);
                if (this.isColumnIndexHidden(columnIndex)) {
                    --columnSpan;
                    columnSpanUpdated = true;
                }
                ++column;
            }
            if (columnSpanUpdated) {
                cell = new SpanningLayerCell(cell, columnSpan, cell.getRowSpan());
            }
        }
        return cell;
    }

    protected synchronized void invalidateCache() {
        this.cachedVisibleColumnIndexPositionMapping = null;
        this.cachedVisibleColumnPositionIndexMapping = null;
        this.cachedHiddenColumnIndexPositionMapping = null;
        this.startXCache = IntIntMaps.mutable.empty();
    }

    private synchronized IntIntMap getCachedVisibleColumnIndexPositionMapping() {
        if (this.cachedVisibleColumnIndexPositionMapping == null) {
            this.cacheVisibleColumnIndexes();
        }
        return this.cachedVisibleColumnIndexPositionMapping;
    }

    private synchronized IntIntMap getCachedVisibleColumnPositionIndexMapping() {
        if (this.cachedVisibleColumnPositionIndexMapping == null) {
            this.cacheVisibleColumnIndexes();
        }
        return this.cachedVisibleColumnPositionIndexMapping;
    }

    private synchronized IntIntMap getCachedHiddenColumnIndexPositionMapping() {
        if (this.cachedHiddenColumnIndexPositionMapping == null) {
            this.cacheVisibleColumnIndexes();
        }
        return this.cachedHiddenColumnIndexPositionMapping;
    }

    protected synchronized void cacheVisibleColumnIndexes() {
        this.cachedVisibleColumnIndexPositionMapping = IntIntMaps.mutable.empty();
        this.cachedVisibleColumnPositionIndexMapping = IntIntMaps.mutable.empty();
        this.cachedHiddenColumnIndexPositionMapping = IntIntMaps.mutable.empty();
        this.startXCache = IntIntMaps.mutable.empty();
        if (this.hasHiddenColumns()) {
            IUniqueIndexLayer underlyingLayer = this.getUnderlyingLayer();
            int columnPosition = 0;
            int parentColumnPosition = 0;
            while (parentColumnPosition < underlyingLayer.getColumnCount()) {
                int columnIndex = underlyingLayer.getColumnIndexByPosition(parentColumnPosition);
                if (!this.isColumnIndexHidden(columnIndex)) {
                    this.cachedVisibleColumnIndexPositionMapping.put(columnIndex, columnPosition);
                    this.cachedVisibleColumnPositionIndexMapping.put(columnPosition, columnIndex);
                    ++columnPosition;
                } else {
                    this.cachedHiddenColumnIndexPositionMapping.put(columnIndex, columnPosition);
                }
                ++parentColumnPosition;
            }
        }
    }
}

