/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.EditController;
import org.eclipse.nebula.widgets.nattable.edit.command.EditSelectionCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.event.InlineCellEditEvent;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.widgets.Composite;

public class EditSelectionCommandHandler
extends AbstractLayerCommandHandler<EditSelectionCommand> {
    private SelectionLayer selectionLayer;
    private IUniqueIndexLayer upperLayer;

    public EditSelectionCommandHandler(SelectionLayer selectionLayer) {
        this(selectionLayer, null);
    }

    public EditSelectionCommandHandler(SelectionLayer selectionLayer, IUniqueIndexLayer upperLayer) {
        this.selectionLayer = selectionLayer;
        this.upperLayer = upperLayer;
    }

    @Override
    public Class<EditSelectionCommand> getCommandClass() {
        return EditSelectionCommand.class;
    }

    @Override
    public boolean doCommand(EditSelectionCommand command) {
        Composite parent = command.getParent();
        IConfigRegistry configRegistry = command.getConfigRegistry();
        Character initialValue = command.getCharacter();
        Collection<ILayerCell> selectedCells = this.getCellsForEditing(this.selectionLayer, this.upperLayer, configRegistry, command.isByTraversal());
        if (selectedCells.size() == 1) {
            ILayerCell cell = selectedCells.iterator().next();
            this.selectionLayer.fireLayerEvent(new InlineCellEditEvent(new PositionCoordinate(this.selectionLayer, cell.getOriginColumnPosition(), cell.getOriginRowPosition()), parent, configRegistry, initialValue != null ? initialValue : cell.getDataValue()));
        } else if (selectedCells.size() > 1) {
            Object initialEditValue = initialValue;
            if (initialValue == null && EditUtils.isValueSame(selectedCells)) {
                ILayerCell cell = selectedCells.iterator().next();
                initialEditValue = this.selectionLayer.getDataValueByPosition(cell.getColumnPosition(), cell.getRowPosition());
            }
            EditController.editCells(selectedCells, parent, initialEditValue, configRegistry);
        }
        return true;
    }

    protected Collection<ILayerCell> getCellsForEditing(SelectionLayer selectionLayer, IUniqueIndexLayer upperLayer, IConfigRegistry configRegistry, boolean byTraversal) {
        Collection<ILayerCell> selectedCells;
        Collection<ILayerCell> collection = selectedCells = this.handleOnlyAllSelectedEditable(configRegistry) ? EditUtils.getSelectedCellsForEditing(selectionLayer, upperLayer) : EditUtils.getEditableCellsInSelection(selectionLayer, upperLayer, configRegistry);
        if (EditUtils.allCellsEditable(selectedCells, configRegistry) && EditUtils.isEditorSame(selectedCells, configRegistry) && EditUtils.isConverterSame(selectedCells, configRegistry) && EditUtils.activateLastSelectedCellEditor(selectionLayer, configRegistry, byTraversal)) {
            return selectedCells;
        }
        return Collections.emptyList();
    }

    protected boolean handleOnlyAllSelectedEditable(IConfigRegistry configRegistry) {
        Boolean allEditable = configRegistry.getConfigAttribute(EditConfigAttributes.MULTI_EDIT_ALL_SELECTED_EDITABLE, DisplayMode.EDIT, new String[0]);
        return allEditable == null ? true : allEditable;
    }
}

