/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.datachange;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.datachange.AbstractDataChangeHandler;
import org.eclipse.nebula.widgets.nattable.datachange.CellKeyHandler;
import org.eclipse.nebula.widgets.nattable.datachange.DataChangeLayer;
import org.eclipse.nebula.widgets.nattable.datachange.RowInsertDataChange;
import org.eclipse.nebula.widgets.nattable.datachange.event.KeyRowInsertEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowInsertEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowInsertDataChangeHandler
extends AbstractDataChangeHandler<RowInsertDataChange>
implements ILayerEventHandler<RowInsertEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(RowInsertDataChangeHandler.class);

    public RowInsertDataChangeHandler(DataChangeLayer layer, CellKeyHandler<?> keyHandler) {
        super(layer, keyHandler, new ConcurrentHashMap());
    }

    @Override
    public void handleStructuralChange(IStructuralChangeEvent structuralChangeEvent) {
        if (structuralChangeEvent.isVerticalStructureChanged() && structuralChangeEvent.getRowDiffs() != null && this.keyHandler.updateOnVerticalStructuralChange()) {
            Collection<StructuralDiff> structuralDiffs = structuralChangeEvent.getRowDiffs();
            this.handleRowDelete(structuralDiffs);
            this.handleRowInsert(structuralDiffs);
        }
    }

    private void handleRowDelete(Collection<StructuralDiff> rowDiffs) {
        ArrayList<StructuralDiff> diffs = new ArrayList<StructuralDiff>(rowDiffs);
        Collections.sort(diffs, (o1, o2) -> o1.getBeforePositionRange().start - o2.getBeforePositionRange().start);
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (StructuralDiff rowDiff : diffs) {
            if (rowDiff.getDiffType() == null || !rowDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
            Range beforePositionRange = rowDiff.getBeforePositionRange();
            int i = beforePositionRange.start;
            while (i < beforePositionRange.end) {
                int index = i;
                if (index >= 0) {
                    toRemove.add(index);
                }
                ++i;
            }
        }
        if (!toRemove.isEmpty()) {
            HashMap modifiedRows = new HashMap();
            for (Map.Entry entry : this.dataChanges.entrySet()) {
                int rowIndex = this.keyHandler.getRowIndex(entry.getKey());
                if (toRemove.contains(rowIndex)) continue;
                int deletedBefore = 0;
                for (Integer removed : toRemove) {
                    if (removed >= rowIndex) continue;
                    ++deletedBefore;
                }
                int modRow = rowIndex - deletedBefore;
                if (modRow < 0) continue;
                Object oldKey = entry.getKey();
                Object updatedKey = this.keyHandler.getKeyWithRowUpdate(oldKey, modRow);
                ((RowInsertDataChange)entry.getValue()).updateKey(updatedKey);
                modifiedRows.put(updatedKey, (RowInsertDataChange)entry.getValue());
            }
            this.dataChanges.clear();
            this.dataChanges.putAll(modifiedRows);
        }
    }

    private void handleRowInsert(Collection<StructuralDiff> rowDiffs) {
        ArrayList<StructuralDiff> diffs = new ArrayList<StructuralDiff>(rowDiffs);
        Collections.sort(diffs, (o1, o2) -> o2.getBeforePositionRange().start - o1.getBeforePositionRange().start);
        for (StructuralDiff rowDiff : diffs) {
            if (rowDiff.getDiffType() == null || !rowDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
            Range beforePositionRange = rowDiff.getBeforePositionRange();
            HashMap modifiedRows = new HashMap();
            for (Map.Entry entry : this.dataChanges.entrySet()) {
                int rowIndex = this.keyHandler.getRowIndex(entry.getKey());
                int modRow = -1;
                modRow = rowIndex >= beforePositionRange.start ? rowIndex + 1 : rowIndex;
                Object updatedKey = this.keyHandler.getKeyWithRowUpdate(entry.getKey(), modRow);
                ((RowInsertDataChange)entry.getValue()).updateKey(updatedKey);
                modifiedRows.put(updatedKey, (RowInsertDataChange)entry.getValue());
            }
            this.dataChanges.clear();
            this.dataChanges.putAll(modifiedRows);
        }
    }

    @Override
    public boolean isColumnDirty(int columnPosition) {
        return !this.dataChanges.isEmpty();
    }

    @Override
    public boolean isRowDirty(int rowPosition) {
        Object key = this.keyHandler.getKey(-1, rowPosition);
        if (key != null) {
            return this.dataChanges.containsKey(key);
        }
        return false;
    }

    @Override
    public boolean isCellDirty(int columnPosition, int rowPosition) {
        return this.isRowDirty(rowPosition);
    }

    @Override
    public boolean isDirty() {
        return !this.dataChanges.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void handleLayerEvent(RowInsertEvent event) {
        if (this.handleDataUpdate) {
            Map map = this.dataChanges;
            synchronized (map) {
                if (event instanceof KeyRowInsertEvent) {
                    KeyRowInsertEvent e = (KeyRowInsertEvent)event;
                    ArrayList<Object> keys = new ArrayList<Object>(e.getKeys());
                    Collections.reverse(keys);
                    for (Object e2 : keys) {
                        this.dataChanges.put(e2, new RowInsertDataChange(e2, e.getKeyHandler()));
                        this.layer.addDataChange(new RowInsertDataChange(e2, e.getKeyHandler()));
                    }
                } else {
                    void var5_11;
                    int[] positions;
                    int[] nArray = positions = PositionUtil.getPositions(event.getRowPositionRanges());
                    int n = positions.length;
                    boolean n2 = false;
                    while (var5_11 < n) {
                        int i = nArray[var5_11];
                        Object key = this.keyHandler.getKey(-1, i);
                        if (key != null) {
                            this.dataChanges.put(key, new RowInsertDataChange(key, this.keyHandler));
                            this.layer.addDataChange(new RowInsertDataChange(key, this.keyHandler));
                        } else {
                            LOG.warn("key was null for position {}", (Object)i);
                        }
                        ++var5_11;
                    }
                }
            }
        }
    }

    @Override
    public Class<RowInsertEvent> getLayerEventClass() {
        return RowInsertEvent.class;
    }
}

