/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.ui.contributions;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.uml.alf.Expression;
import org.eclipse.papyrus.uml.profile.structure.AppliedStereotypeProperty;
import org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.AppliedStereotypePropertyEditorUtil;
import org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.appliedStereotypeProperty.AppliedStereotypePropertyRule;
import org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.ui.internal.AppliedStereotypePropertyActivator;
import org.eclipse.papyrus.uml.xtext.integration.DefaultXtextDirectEditorConfiguration;
import org.eclipse.papyrus.uml.xtext.integration.XtextFakeResourceContext;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementAdapter;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.StringInputStream;

public class StereotypePropertyEditorConfigurationContribution
extends DefaultXtextDirectEditorConfiguration {
    protected static AppliedStereotypeProperty statocAppliedStereotypeProperty;

    public static AppliedStereotypeProperty getAppliedStereoProperty() {
        return statocAppliedStereotypeProperty;
    }

    public Object preEditAction(Object objectToEdit) {
        if (objectToEdit instanceof AppliedStereotypeProperty) {
            statocAppliedStereotypeProperty = (AppliedStereotypeProperty)objectToEdit;
        }
        return super.preEditAction(objectToEdit);
    }

    public Injector getInjector() {
        return AppliedStereotypePropertyActivator.getInstance().getInjector("org.eclipse.papyrus.uml.textedit.stereotypeproperty.xtext.AppliedStereotypeProperty");
    }

    protected ICommand getParseCommand(EObject umlObject, EObject xtextObject) {
        umlObject = (EObject)this.objectToEdit;
        CompositeCommand command = new CompositeCommand("");
        AppliedStereotypeProperty appliedStereotypeProperty = (AppliedStereotypeProperty)umlObject;
        Type type = appliedStereotypeProperty.getStereotypeProperty().getType();
        ICommand specificCommand = null;
        if (type.getName().equals("Integer") || type.getName().equals("Boolean") || type.getName().equals("String")) {
            specificCommand = this.reconcilePrimitiveType(appliedStereotypeProperty, xtextObject);
        } else if (type.eClass().getName().equals("Stereotype")) {
            specificCommand = this.reconcileRefToStereotypeApp(appliedStereotypeProperty, xtextObject);
        } else if (type instanceof Enumeration) {
            specificCommand = this.reconcileEnumerationLiteral(appliedStereotypeProperty, xtextObject);
        } else if (type instanceof Element) {
            specificCommand = this.reconcileRefToElement(appliedStereotypeProperty, xtextObject);
        }
        if (specificCommand != null) {
            command.add((IUndoableOperation)specificCommand);
        }
        return command;
    }

    private List<NamedElement> getEnumerationCandidates(Enumeration enumeration) {
        ArrayList<NamedElement> tmp = new ArrayList<NamedElement>((Collection<NamedElement>)enumeration.getMembers());
        tmp.removeAll((Collection<?>)enumeration.getImportedMembers());
        return tmp;
    }

    protected ICommand reconcileEnumerationLiteral(AppliedStereotypeProperty appliedStereotypeProperty, EObject model) {
        Property property = appliedStereotypeProperty.getStereotypeProperty();
        List<NamedElement> candidates = this.getEnumerationCandidates((Enumeration)property.getType());
        Expression expression = this.getValueSpecificationExpression(model);
        List results = AppliedStereotypePropertyEditorUtil.resolveEnumerationLiteralValue((Expression)expression, candidates);
        if (property.getUpper() == 1) {
            if (!results.isEmpty()) {
                return this.createUpdateCommand(appliedStereotypeProperty, results.get(0));
            }
            return this.createUpdateCommand(appliedStereotypeProperty, null);
        }
        if (results.isEmpty()) {
            return this.createUpdateCommand(appliedStereotypeProperty, new ArrayList());
        }
        return this.createUpdateCommand(appliedStereotypeProperty, results);
    }

    protected ICommand reconcileRefToStereotypeApp(AppliedStereotypeProperty appliedStereotypeProperty, EObject model) {
        Property property = appliedStereotypeProperty.getStereotypeProperty();
        Expression expression = this.getValueSpecificationExpression(model);
        Element scope = appliedStereotypeProperty.getBaseElement();
        List references = AppliedStereotypePropertyEditorUtil.resolveReferenceValue((Expression)expression, (Element)scope);
        List<EObject> stereotypeApplications = this.getStereotypeApplication(references, (Stereotype)property.getType());
        if (property.getUpper() == 1) {
            if (!stereotypeApplications.isEmpty()) {
                return this.createUpdateCommand(appliedStereotypeProperty, stereotypeApplications.get(0));
            }
            return this.createUpdateCommand(appliedStereotypeProperty, null);
        }
        return this.createUpdateCommand(appliedStereotypeProperty, stereotypeApplications);
    }

    private List<EObject> getStereotypeApplication(List<NamedElement> references, Stereotype stereotype) {
        ArrayList<EObject> stereotypeApplications = new ArrayList<EObject>();
        for (NamedElement element : references) {
            if (!element.isStereotypeApplied(stereotype)) continue;
            stereotypeApplications.add(element.getStereotypeApplication(stereotype));
        }
        return stereotypeApplications;
    }

    private Expression getValueSpecificationExpression(EObject model) {
        Expression valueSpecification = null;
        if (model instanceof AppliedStereotypePropertyRule && ((AppliedStereotypePropertyRule)model).getValue() != null) {
            valueSpecification = ((AppliedStereotypePropertyRule)model).getValue().getExpression();
        }
        return valueSpecification;
    }

    protected ICommand reconcilePrimitiveType(AppliedStereotypeProperty appliedStereotypeProperty, EObject model) {
        Expression valueSpecification = this.getValueSpecificationExpression(model);
        if (valueSpecification != null) {
            List values = AppliedStereotypePropertyEditorUtil.resolvePrimitiveValue((Expression)valueSpecification);
            if (appliedStereotypeProperty.getStereotypeProperty().getUpper() == 1) {
                if (values.isEmpty()) {
                    return this.createUpdateCommand(appliedStereotypeProperty, null);
                }
                return this.createUpdateCommand(appliedStereotypeProperty, values.get(0));
            }
            return this.createUpdateCommand(appliedStereotypeProperty, values);
        }
        return null;
    }

    protected ICommand reconcileRefToElement(AppliedStereotypeProperty appliedStereotypeProperty, EObject model) {
        Expression valueSpecification = this.getValueSpecificationExpression(model);
        Element scope = appliedStereotypeProperty.getBaseElement();
        List references = AppliedStereotypePropertyEditorUtil.resolveReferenceValue((Expression)valueSpecification, (Element)scope);
        if (appliedStereotypeProperty.getStereotypeProperty().getUpper() == 1) {
            if (!references.isEmpty()) {
                return this.createUpdateCommand(appliedStereotypeProperty, references.get(0));
            }
            return this.createUpdateCommand(appliedStereotypeProperty, null);
        }
        return this.createUpdateCommand(appliedStereotypeProperty, references);
    }

    protected ICommand createUpdateCommand(final AppliedStereotypeProperty appliedStereotypeProperty, final Object value) {
        AbstractTransactionalCommand setValueCommand = new AbstractTransactionalCommand(TransactionUtil.getEditingDomain((EObject)appliedStereotypeProperty.getStereotypeProperty()), "", Collections.EMPTY_LIST){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                appliedStereotypeProperty.getBaseElement().setValue(appliedStereotypeProperty.getStereotype(), appliedStereotypeProperty.getStereotypeProperty().getName(), value);
                return CommandResult.newOKCommandResult();
            }
        };
        return setValueCommand;
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof AppliedStereotypeProperty) {
            return AppliedStereotypePropertyEditorUtil.getLabel((AppliedStereotypeProperty)((AppliedStereotypeProperty)editedObject)).trim();
        }
        return "<UNDEFINED>";
    }

    public IParser createParser(final EObject semanticObject) {
        return new IParser(){

            public String getEditString(IAdaptable element, int flags) {
                return StereotypePropertyEditorConfigurationContribution.this.getTextToEdit(StereotypePropertyEditorConfigurationContribution.this.objectToEdit);
            }

            public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
                CompositeCommand result = new CompositeCommand("validation");
                ContextElementAdapter.IContextElementProvider provider = StereotypePropertyEditorConfigurationContribution.this.getContextProvider();
                XtextFakeResourceContext context = new XtextFakeResourceContext(StereotypePropertyEditorConfigurationContribution.this.getInjector());
                context.getFakeResource().eAdapters().add((Object)new ContextElementAdapter(provider));
                try {
                    context.getFakeResource().load((InputStream)new StringInputStream(newString), Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (provider instanceof ContextElementAdapter.IContextElementProviderWithInit) {
                    ((ContextElementAdapter.IContextElementProviderWithInit)provider).initResource(context.getFakeResource());
                }
                EcoreUtil2.resolveLazyCrossReferences((Resource)context.getFakeResource(), (CancelIndicator)CancelIndicator.NullImpl);
                if (!context.getFakeResource().getParseResult().hasSyntaxErrors() && context.getFakeResource().getErrors().size() == 0) {
                    EObject xtextObject = context.getFakeResource().getParseResult().getRootASTElement();
                    result.add((IUndoableOperation)StereotypePropertyEditorConfigurationContribution.this.getParseCommand(semanticObject, xtextObject));
                } else {
                    result.add((IUndoableOperation)StereotypePropertyEditorConfigurationContribution.this.createInvalidStringCommand(newString, semanticObject));
                }
                return result;
            }

            public String getPrintString(IAdaptable element, int flags) {
                return StereotypePropertyEditorConfigurationContribution.this.getTextToEdit(StereotypePropertyEditorConfigurationContribution.this.objectToEdit);
            }

            public boolean isAffectingEvent(Object event, int flags) {
                return false;
            }

            public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
                return null;
            }

            public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
                return null;
            }
        };
    }
}

