/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.sequence.services.reorder;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.SequenceDiagramOrderServices;
import org.eclipse.papyrus.sirius.uml.diagram.sequence.services.utils.SequenceDiagramUMLHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class SequenceDiagramEndReorderHelper {
    private final SequenceDiagramOrderServices orderService = new SequenceDiagramOrderServices();
    private final SequenceDiagramUMLHelper umlHelper = new SequenceDiagramUMLHelper();

    public void applyBothEndsReorder(Element interactionElement, EAnnotation newStartingEndPredecessor, EAnnotation newFinishingEndPredecessor, List<EAnnotation> endsOrdering) {
        EAnnotation startEnd = Objects.requireNonNull(this.orderService.getStartingEnd(interactionElement));
        EAnnotation finishEnd = Objects.requireNonNull(this.orderService.getFinishingEnd(interactionElement));
        List<Object> innerEndsToMove = Collections.emptyList();
        if (interactionElement instanceof InteractionFragment) {
            InteractionFragment fragment = (InteractionFragment)interactionElement;
            innerEndsToMove = endsOrdering.subList(endsOrdering.indexOf(startEnd) + 1, endsOrdering.indexOf(finishEnd)).stream().filter(end -> this.isEndInFragment((EAnnotation)end, fragment)).toList();
        }
        endsOrdering.remove(startEnd);
        endsOrdering.remove(finishEnd);
        endsOrdering.removeAll(innerEndsToMove);
        int newStartEndIndex = endsOrdering.indexOf(newStartingEndPredecessor) + 1;
        endsOrdering.add(newStartEndIndex, startEnd);
        endsOrdering.addAll(newStartEndIndex + 1, innerEndsToMove);
        if (newStartingEndPredecessor == newFinishingEndPredecessor || newFinishingEndPredecessor == startEnd) {
            endsOrdering.add(newStartEndIndex + innerEndsToMove.size() + 1, finishEnd);
        } else {
            endsOrdering.add(endsOrdering.indexOf(newFinishingEndPredecessor) + 1, finishEnd);
        }
    }

    public void applySingleEndReorder(Element interactionElement, boolean start, EAnnotation predecessor, List<EAnnotation> endsOrdering) {
        EAnnotation end = start ? this.orderService.getStartingEnd(interactionElement) : this.orderService.getFinishingEnd(interactionElement);
        endsOrdering.remove(end);
        int newEndIndex = endsOrdering.indexOf(predecessor) + 1;
        endsOrdering.add(newEndIndex, end);
    }

    private boolean isEndInFragment(EAnnotation end, InteractionFragment fragment) {
        boolean isEndInFragment = false;
        NamedElement semanticEnd = this.orderService.getEndFragment(end);
        if (semanticEnd instanceof MessageOccurrenceSpecification) {
            InteractionFragment otherEndFragment;
            MessageOccurrenceSpecification messageOccurrenceSpecification = (MessageOccurrenceSpecification)semanticEnd;
            NamedElement otherEnd = this.umlHelper.getOtherEnd((OccurrenceSpecification)messageOccurrenceSpecification);
            isEndInFragment = this.umlHelper.isCoveringASubsetOf((NamedElement)messageOccurrenceSpecification, (NamedElement)fragment) || otherEnd instanceof InteractionFragment && this.umlHelper.isCoveringASubsetOf((NamedElement)(otherEndFragment = (InteractionFragment)otherEnd), (NamedElement)fragment);
        } else if (semanticEnd instanceof InteractionFragment) {
            InteractionFragment endInteractionFragment = (InteractionFragment)semanticEnd;
            isEndInFragment = this.umlHelper.isCoveringASubsetOf((NamedElement)endInteractionFragment, (NamedElement)fragment);
        }
        return isEndInFragment;
    }
}

