/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.api;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.nattable.common.helper.TableViewPrototype;
import org.eclipse.papyrus.infra.nattable.common.modelresource.PapyrusNattableModel;
import org.eclipse.papyrus.infra.nattable.internal.common.commands.CreateAndOpenTableEditorCommand;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableconfiguration.TableConfiguration;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class TableEditorCreationHelper {
    private EObject tableContext;
    private EObject tableOwner;
    private String tableType;
    private String tableName;
    private String tableDescription;
    private boolean openCreatedEditor;
    private ServicesRegistry servicesRegistry;
    private ModelSet modelSet;
    private PapyrusNattableModel papyrusNattableModel;
    private TableViewPrototype tableViewPrototype;
    private TableConfiguration tableConfiguration;
    private TransactionalEditingDomain editingDomain;
    private IPageManager pageMngr;
    private Command creationCommand;

    public TableEditorCreationHelper(EObject tableContext, String tableType, String name, boolean openCreatedEditor) {
        this(tableContext, tableType, name, openCreatedEditor, null, null);
    }

    public TableEditorCreationHelper(EObject tableContext, String tableType, String name, boolean openCreatedEditor, String description) {
        this(tableContext, tableType, name, openCreatedEditor, null, description);
    }

    public TableEditorCreationHelper(EObject tableContext, String tableType, String name, boolean openCreatedEditor, EObject tableOwner) {
        this(tableContext, tableType, name, openCreatedEditor, tableOwner, null);
    }

    public TableEditorCreationHelper(EObject tableContext, String tableType, String name, boolean openCreatedEditor, EObject tableOwner, String description) {
        this.tableContext = tableContext;
        this.tableOwner = tableOwner;
        this.tableType = tableType;
        this.tableName = name;
        this.tableDescription = description;
        this.openCreatedEditor = openCreatedEditor;
    }

    public IStatus canCreateTable() {
        String pluginID = this.getPluginID();
        if (this.tableContext == null) {
            return new Status(4, pluginID, 5, "The table context is null", null);
        }
        if (this.tableType == null) {
            return new Status(4, pluginID, 6, "The table type is null", null);
        }
        if (this.tableName == null || this.tableName.isEmpty()) {
            return new Status(4, pluginID, 7, "The name of the table to create is null or empty", null);
        }
        try {
            this.servicesRegistry = ServiceUtilsForResource.getInstance().getServiceRegistry(this.tableContext.eResource());
        }
        catch (ServiceException e) {
            return new Status(4, pluginID, 1, e.getMessage(), (Throwable)e);
        }
        try {
            this.modelSet = ServiceUtils.getInstance().getModelSet((Object)this.servicesRegistry);
        }
        catch (ServiceException e) {
            return new Status(4, pluginID, 2, e.getMessage(), (Throwable)e);
        }
        try {
            this.editingDomain = ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.servicesRegistry);
        }
        catch (ServiceException e) {
            return new Status(4, pluginID, 3, e.getMessage(), (Throwable)e);
        }
        if (this.editingDomain == null) {
            return new Status(4, pluginID, 3, "The editing domain has not been found", null);
        }
        try {
            this.pageMngr = (IPageManager)ServiceUtils.getInstance().getService(IPageManager.class, (Object)this.servicesRegistry);
        }
        catch (ServiceException e) {
            return new Status(4, pluginID, 4, e.getMessage(), (Throwable)e);
        }
        if (this.pageMngr == null) {
            return new Status(4, pluginID, 4, "The page manager has not be found", null);
        }
        try {
            this.papyrusNattableModel = (PapyrusNattableModel)this.modelSet.getModelChecked("org.eclipse.papyrus.infra.nattable.resource.NattableModel");
        }
        catch (NotFoundException e) {
            return new Status(4, pluginID, 8, e.getMessage(), (Throwable)e);
        }
        if (this.papyrusNattableModel == null) {
            return new Status(4, pluginID, 8, "Papyrus Nattable Model not found", null);
        }
        this.tableViewPrototype = this.getTableViewPrototype(this.tableContext, this.tableType);
        if (this.tableViewPrototype == null) {
            return new Status(4, pluginID, 9, NLS.bind((String)"The View Prototype to create a {0} table has not been found", (Object)this.tableType), null);
        }
        this.tableConfiguration = this.getTableConfiguration(this.tableViewPrototype);
        if (this.tableConfiguration == null) {
            return new Status(4, pluginID, 11, NLS.bind((String)"Table configuration not found for the table type {0}", (Object)this.tableType), null);
        }
        this.creationCommand = this.getCreateTableEditorCommand();
        if (this.creationCommand == null) {
            return new Status(4, pluginID, 12, "The creation command cannot be created", null);
        }
        if (!this.creationCommand.canExecute()) {
            return new Status(4, pluginID, 13, "The creation command is not executable", null);
        }
        return Status.OK_STATUS;
    }

    protected String getPluginID() {
        return "org.eclipse.papyrus.infra.nattable.common";
    }

    public Command getCreateTableEditorCommand() {
        EObject tableOwner = this.tableOwner;
        if (tableOwner == null) {
            this.tableOwner = this.tableContext;
        }
        if (this.openCreatedEditor) {
            return new CreateAndOpenTableEditorCommand(this.editingDomain, this.papyrusNattableModel, this.tableViewPrototype, this.tableConfiguration, this.tableContext, this.tableName, tableOwner, this.tableDescription, this.pageMngr);
        }
        return new CreateAndOpenTableEditorCommand(this.editingDomain, this.papyrusNattableModel, this.tableViewPrototype, this.tableConfiguration, this.tableContext, this.tableName, tableOwner, this.tableDescription, null);
    }

    public Table createTableEditor() {
        if (this.canCreateTable().isOK()) {
            Object res;
            Collection result;
            if (this.creationCommand != null && this.creationCommand.canExecute()) {
                this.editingDomain.getCommandStack().execute(this.creationCommand);
            }
            if (this.creationCommand != null && (result = this.creationCommand.getResult()).size() > 0 && (res = result.iterator().next()) instanceof Table) {
                return (Table)res;
            }
        }
        return null;
    }

    protected TableConfiguration getTableConfiguration(TableViewPrototype viewPrototype) {
        Assert.isNotNull((Object)((Object)viewPrototype));
        if (viewPrototype.getRepresentationKind() instanceof PapyrusTable) {
            PapyrusTable papyrusTable = (PapyrusTable)viewPrototype.getRepresentationKind();
            return papyrusTable.getConfiguration();
        }
        return null;
    }

    protected TableViewPrototype getTableViewPrototype(EObject tableContext, String tableType) {
        if (tableContext == null || tableType == null) {
            return null;
        }
        Collection prototypes = PolicyChecker.getFor((EObject)tableContext).getPrototypesFor(tableContext);
        for (ViewPrototype current : prototypes) {
            PapyrusTable papyrusTable;
            TableConfiguration configuration;
            PapyrusRepresentationKind representationKind;
            if (!(current instanceof TableViewPrototype)) continue;
            TableViewPrototype prototype = (TableViewPrototype)current;
            String implementationID = prototype.getImplementation();
            if (tableType.equals(implementationID)) {
                return prototype;
            }
            if (implementationID != null && !implementationID.isEmpty() || !((representationKind = prototype.getRepresentationKind()) instanceof PapyrusTable) || !(configuration = (papyrusTable = (PapyrusTable)representationKind).getConfiguration()).getType().equals(tableType)) continue;
            return prototype;
        }
        return null;
    }

    public void setTableContext(EObject tableContext) {
        this.tableContext = tableContext;
    }

    public void setTableOwner(EObject tableOwner) {
        this.tableOwner = tableOwner;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public void setTableName(String name) {
        this.tableName = name;
    }

    public void setTableDescription(String description) {
        this.tableDescription = description;
    }
}

