/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.internal.stereotypes;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.services.markerlistener.providers.IMarkerProvider;
import org.eclipse.papyrus.infra.services.markerlistener.util.MarkerListenerUtils;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.AbstractRepairAction;
import org.eclipse.papyrus.uml.modelrepair.internal.stereotypes.IRepairAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CreateMarkersAction
extends AbstractRepairAction {
    static final CreateMarkersAction INSTANCE = new CreateMarkersAction();

    private CreateMarkersAction() {
        super(IRepairAction.Kind.CREATE_MARKERS);
    }

    @Override
    public boolean repair(Resource resource, EPackage profileDefinition, Collection<? extends EObject> stereotypeApplications, DiagnosticChain problems, IProgressMonitor monitor) {
        List providers = MarkerListenerUtils.getMarkerProviders((Resource)resource);
        if (!providers.isEmpty()) {
            IMarkerProvider provider = (IMarkerProvider)providers.get(0);
            BasicDiagnostic diagnostics = new BasicDiagnostic();
            for (EObject eObject : stereotypeApplications) {
                Element subject = CreateMarkersAction.getBaseElement((EObject)eObject);
                if (subject == null) {
                    subject = eObject;
                }
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.papyrus.uml.modelrepair", 0, "Obsolete application of stereotype " + UMLUtil.UML2EcoreConverter.getOriginalName((ENamedElement)eObject.eClass()), new Object[]{subject, eObject}));
            }
            try {
                provider.createMarkers(resource, (Diagnostic)diagnostics, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)"Creating problem markers...", (int)stereotypeApplications.size()));
            }
            catch (CoreException coreException) {
                if (problems == null) {
                    Activator.log.error((Throwable)coreException);
                }
                problems.add(BasicDiagnostic.toDiagnostic((IStatus)coreException.getStatus()));
            }
        }
        return true;
    }
}

