/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.gmf.internal.common.codegen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ListIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;

class PackageReferencesCollector
extends ASTVisitor {
    private Collection<SimpleName> mySimpleTypeReferences;
    private Collection<Name> myQualifiedTypeReferences;
    private Collection<String> myImportDeclarations;
    private Collection<String> myKnownPackages = new HashSet<String>();
    private Collection<String> myHardcodedTypes;

    public static void collect(ASTNode node, Collection<Name> resultingQualifiedTypeReferences, Collection<SimpleName> resultingSimpleTypeReferences, Collection<String> resultingImportDeclarations) {
        node.accept((ASTVisitor)new PackageReferencesCollector(resultingQualifiedTypeReferences, resultingSimpleTypeReferences, resultingImportDeclarations));
    }

    public static void collect(ASTNode node, Collection<Name> resultingQualifiedTypeReferences, Collection<SimpleName> resultingSimpleTypeReferences, Collection<String> resultingImportDeclarations, Collection<String> hardcodedTypeNames) {
        node.accept((ASTVisitor)new PackageReferencesCollector(resultingQualifiedTypeReferences, resultingSimpleTypeReferences, resultingImportDeclarations, hardcodedTypeNames));
    }

    private PackageReferencesCollector(Collection<Name> resultingTypeReferences, Collection<SimpleName> resultingSimpleTypeReferences, Collection<String> resultingImportDeclarations) {
        this(resultingTypeReferences, resultingSimpleTypeReferences, resultingImportDeclarations, null);
    }

    private PackageReferencesCollector(Collection<Name> resultingTypeReferences, Collection<SimpleName> resultingSimpleTypeReferences, Collection<String> resultingImportDeclarations, Collection<String> hardcodedTypes) {
        super(true);
        this.myQualifiedTypeReferences = resultingTypeReferences;
        this.mySimpleTypeReferences = resultingSimpleTypeReferences;
        this.myImportDeclarations = resultingImportDeclarations;
        this.myHardcodedTypes = hardcodedTypes;
    }

    private void addQualifiedReference(QualifiedName node) {
        this.myKnownPackages.add(node.getQualifier().getFullyQualifiedName());
        this.myQualifiedTypeReferences.add((Name)node);
    }

    private void addSimpleReference(SimpleName name) {
        this.mySimpleTypeReferences.add(name);
    }

    private void addImport(Name name) {
        if (name.isQualifiedName()) {
            QualifiedName qName = (QualifiedName)name;
            this.myImportDeclarations.add(qName.getName().getFullyQualifiedName());
            this.myKnownPackages.add(qName.getQualifier().getFullyQualifiedName());
        } else {
            this.addSimpleReference((SimpleName)name);
        }
    }

    protected void typeRefFound(Name node) {
        Name name = node;
        if (node.isQualifiedName() && (name = this.hackRecognizeTypesAndPackagesForTheirLettersCase((QualifiedName)node)) == null) {
            return;
        }
        if (name.isQualifiedName()) {
            this.addQualifiedReference((QualifiedName)name);
        } else {
            this.addSimpleReference((SimpleName)name);
        }
    }

    protected Name hackRecognizeTypesAndPackagesForTheirLettersCase(QualifiedName node) {
        QualifiedName name = node;
        ArrayList<QualifiedName> qualifiers = new ArrayList<QualifiedName>();
        while (name.isQualifiedName()) {
            qualifiers.add(name);
            name = name.getQualifier();
        }
        qualifiers.add(name);
        ListIterator it = qualifiers.listIterator(qualifiers.size());
        while (it.hasPrevious()) {
            int i;
            Name packagePart = (Name)it.previous();
            if (this.getHardcodedTypes().contains(packagePart.getFullyQualifiedName())) {
                return packagePart;
            }
            SimpleName lastPart = packagePart.isSimpleName() ? (SimpleName)packagePart : ((QualifiedName)packagePart).getName();
            char[] letters = lastPart.getFullyQualifiedName().toCharArray();
            if (letters.length <= 0) continue;
            if (Character.isUpperCase(letters[0])) {
                i = 0;
                while (i < letters.length) {
                    if (Character.isLowerCase(letters[i])) {
                        return packagePart;
                    }
                    ++i;
                }
                continue;
            }
            i = 0;
            while (i < letters.length) {
                if (!Character.isLowerCase(letters[i]) && !Character.isDigit(letters[i])) {
                    return null;
                }
                ++i;
            }
        }
        return null;
    }

    public Collection<String> getHardcodedTypes() {
        if (this.myHardcodedTypes == null) {
            this.myHardcodedTypes = new HashSet<String>();
            this.initializeDefaultHardcodedTypes(this.myHardcodedTypes);
        }
        return this.myHardcodedTypes;
    }

    protected void initializeDefaultHardcodedTypes(Collection<String> container) {
        container.add(SWT.class.getCanonicalName());
        container.add(NLS.class.getCanonicalName());
        container.add(URI.class.getCanonicalName());
    }

    public boolean visit(ImportDeclaration node) {
        if (node.isOnDemand()) {
            this.myKnownPackages.add(node.getName().getFullyQualifiedName());
        } else {
            this.addImport(node.getName());
        }
        return false;
    }

    public boolean visit(PackageDeclaration node) {
        return false;
    }

    public boolean visit(SimpleType node) {
        this.typeRefFound(node.getName());
        return false;
    }

    public boolean visit(TypeDeclaration node) {
        this.addSimpleReference(node.getName());
        return true;
    }

    public boolean visit(QualifiedName node) {
        this.typeRefFound((Name)node);
        return false;
    }
}

