/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class RowReorderEndCommand
implements ILayerCommand {
    private RowPositionCoordinate toRowPositionCoordinate;
    private boolean reorderToTopEdge;

    public RowReorderEndCommand(ILayer layer, int toRowPosition) {
        if (toRowPosition < layer.getRowCount()) {
            this.reorderToTopEdge = true;
        } else {
            this.reorderToTopEdge = false;
            --toRowPosition;
        }
        this.toRowPositionCoordinate = new RowPositionCoordinate(layer, toRowPosition);
    }

    protected RowReorderEndCommand(RowReorderEndCommand command) {
        this.toRowPositionCoordinate = command.toRowPositionCoordinate;
        this.reorderToTopEdge = command.reorderToTopEdge;
    }

    public int getToRowPosition() {
        return this.toRowPositionCoordinate.getRowPosition();
    }

    public void updateToRowPosition(int toPosition) {
        this.toRowPositionCoordinate.rowPosition = toPosition;
    }

    public void toggleCoordinateByEdge() {
        if (this.reorderToTopEdge && this.toRowPositionCoordinate.rowPosition > 0) {
            --this.toRowPositionCoordinate.rowPosition;
            this.reorderToTopEdge = false;
        } else if (!this.reorderToTopEdge && this.toRowPositionCoordinate.rowPosition < this.toRowPositionCoordinate.getLayer().getRowCount() - 1) {
            ++this.toRowPositionCoordinate.rowPosition;
            this.reorderToTopEdge = true;
        }
    }

    public boolean isReorderToTopEdge() {
        return this.reorderToTopEdge;
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        RowPositionCoordinate targetToRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(this.toRowPositionCoordinate, targetLayer);
        if (targetToRowPositionCoordinate != null) {
            this.toRowPositionCoordinate = targetToRowPositionCoordinate;
            return true;
        }
        return false;
    }

    @Override
    public RowReorderEndCommand cloneCommand() {
        return new RowReorderEndCommand(this);
    }
}

