/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.resource;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.resource.DependencyManagementHelper;
import org.eclipse.papyrus.infra.emf.resource.IURIReplacementStrategy;
import org.eclipse.papyrus.infra.emf.resource.Replacement;
import org.eclipse.papyrus.infra.emf.resource.ReplacementImpl;

public class RestoreDependencyHelper {
    protected IURIReplacementStrategy iURIReplacementStrategy;

    public RestoreDependencyHelper(IURIReplacementStrategy iURIReplacementStrategy) {
        this.iURIReplacementStrategy = iURIReplacementStrategy;
    }

    public Collection<Replacement> restoreDependencies(Resource resource) {
        TreeIterator allContentsIterator = resource.getAllContents();
        LinkedList<Replacement> replacements = new LinkedList<Replacement>();
        while (allContentsIterator.hasNext()) {
            EObject eObject = (EObject)allContentsIterator.next();
            for (EReference reference : eObject.eClass().getEAllReferences()) {
                if (reference.isContainment() || !reference.isChangeable()) continue;
                Object value = eObject.eGet((EStructuralFeature)reference);
                if (value instanceof EObject) {
                    EObject eObjectToReplace = (EObject)value;
                    EObject newEObject = this.checkAndReplace(eObjectToReplace);
                    if (newEObject == null) continue;
                    try {
                        eObject.eSet((EStructuralFeature)reference, (Object)newEObject);
                        replacements.add(new ReplacementImpl(eObject, (EStructuralFeature)reference, eObjectToReplace, newEObject));
                    }
                    catch (Exception ex) {
                        Activator.log.error((Throwable)ex);
                    }
                    continue;
                }
                if (!(value instanceof Collection)) continue;
                HashMap<EObject, EObject> previousToNewValue = new HashMap<EObject, EObject>();
                Collection collection = (Collection)value;
                for (Object collectionElement : (Collection)value) {
                    EObject eObjectToReplace;
                    EObject newEObject;
                    if (!(collectionElement instanceof EObject) || (newEObject = this.checkAndReplace(eObjectToReplace = (EObject)collectionElement)) == null) continue;
                    previousToNewValue.put(eObjectToReplace, newEObject);
                }
                if (previousToNewValue.isEmpty() || !(collection instanceof EStructuralFeature.Setting)) continue;
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)collection;
                for (Map.Entry entry : previousToNewValue.entrySet()) {
                    EcoreUtil.replace((EStructuralFeature.Setting)setting, entry.getKey(), entry.getValue());
                    replacements.add(new ReplacementImpl(eObject, (EStructuralFeature)reference, (EObject)entry.getKey(), (EObject)entry.getValue()));
                }
            }
        }
        return replacements;
    }

    protected EObject checkAndReplace(EObject eObject) {
        URI targetURI;
        URI eObjectURIToReplace = EcoreUtil.getURI((EObject)eObject);
        URI resourceURI = eObjectURIToReplace.trimFragment();
        if (!resourceURI.isEmpty() && (targetURI = this.iURIReplacementStrategy.getReplacementCandidate(resourceURI)) != null && !targetURI.equals(resourceURI)) {
            return DependencyManagementHelper.replace(eObject, targetURI);
        }
        return null;
    }
}

