/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OrientedGraph<T> {
    private Map<T, Set<T>> graph;

    public Set<T> getVertices() {
        return this.graph.keySet();
    }

    public Map<T, Set<T>> getEdges() {
        return this.graph;
    }

    public Set<T> getAllConnex(T element) {
        HashSet<T> result = new HashSet<T>();
        Set<T> directChildren = this.graph.get(element);
        if (directChildren != null) {
            result.addAll(directChildren);
            for (T child : directChildren) {
                Set<T> childChildren = this.getAllConnex(child);
                result.addAll(childChildren);
            }
        }
        return result;
    }

    public OrientedGraph() {
        this.graph = new HashMap<T, Set<T>>();
    }

    public OrientedGraph(Map<T, Set<T>> edges) {
        this.graph = edges;
    }

    public void clear() {
        this.graph.clear();
    }

    public void addEdge(T source, T target) {
        if (!this.graph.containsKey(source)) {
            this.addVertex(source);
        }
        if (!this.graph.containsKey(target)) {
            this.addVertex(target);
        }
        this.graph.get(source).add(target);
    }

    public void addVertex(T vertex) {
        if (!this.graph.containsKey(vertex)) {
            this.graph.put(vertex, new HashSet());
        }
    }

    public String toString() {
        Object result = "";
        for (T element : this.graph.keySet()) {
            result = (String)result + "- " + String.valueOf(element) + "\n";
            for (T target : this.graph.get(element)) {
                result = (String)result + "\t-> " + String.valueOf(target) + "\n";
            }
        }
        return result;
    }
}

