/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.internal.treeproxy.EReferenceTreeElement;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.Decoration;
import org.eclipse.papyrus.views.modelexplorer.Activator;
import org.eclipse.papyrus.views.modelexplorer.core.ui.pagebookview.ModelExplorerDecorationAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.navigator.NavigatorDecoratingLabelProvider;

public class DecoratingLabelProviderWTooltips
extends NavigatorDecoratingLabelProvider
implements Observer {
    private DecorationService decorationService;
    protected boolean asyncUpdateRunning;
    protected boolean updatePending;

    public DecoratingLabelProviderWTooltips(ILabelProvider labelProvider, ServicesRegistry servicesRegistry) {
        super(labelProvider);
        try {
            this.decorationService = (DecorationService)servicesRegistry.getService(DecorationService.class);
            this.decorationService.addListener((Observer)this);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void dispose() {
        try {
            if (this.decorationService != null) {
                this.decorationService.deleteListener((Observer)this);
            }
        }
        finally {
            super.dispose();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.decorationService != null && o == this.decorationService) {
            if (!this.asyncUpdateRunning) {
                this.asyncUpdateRunning = true;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        DecoratingLabelProviderWTooltips.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)DecoratingLabelProviderWTooltips.this));
                        while (DecoratingLabelProviderWTooltips.this.updatePending) {
                            DecoratingLabelProviderWTooltips.this.updatePending = false;
                            DecoratingLabelProviderWTooltips.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)DecoratingLabelProviderWTooltips.this));
                        }
                        DecoratingLabelProviderWTooltips.this.asyncUpdateRunning = false;
                    }
                });
            } else {
                this.updatePending = true;
            }
        }
    }

    public String getToolTipText(Object element) {
        if (this.decorationService == null) {
            return null;
        }
        return Decoration.getMessageFromDecorations((DecorationService)this.decorationService, (Object)element);
    }

    public Image getImage(Object element) {
        List decorations;
        Image baseImage = super.getImage(element);
        if (this.decorationService == null) {
            return baseImage;
        }
        ModelExplorerDecorationAdapter adapter = new ModelExplorerDecorationAdapter(baseImage);
        if (element != null && (element instanceof EObject || element instanceof EReferenceTreeElement || EMFHelper.getEObject((Object)element) != null) && (decorations = this.decorationService.getDecorations((Object)EMFHelper.getEObject((Object)element), true)) != null) {
            adapter.setDecorations(decorations);
        }
        return adapter.getDecoratedImage();
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 500;
    }

    public int getToolTipTimeDisplayed(Object object) {
        return 10000;
    }
}

