/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.tests.filters;

import junit.textui.TestRunner;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.ocl.examples.eventmanager.EventFilter;
import org.eclipse.ocl.examples.eventmanager.EventManagerFactory;
import org.eclipse.ocl.examples.eventmanager.filters.ClassFilter;
import org.eclipse.ocl.examples.eventmanager.tests.filters.EventFilterTest;

public class ClassFilterTest
extends EventFilterTest {
    private EClass cls;
    private DynamicEObjectImpl inst;
    private NotificationImpl noti;
    private EClass superCls;
    EClass cls1 = EcoreFactory.eINSTANCE.createEClass();
    EClass cls2 = EcoreFactory.eINSTANCE.createEClass();
    EClass testCls = EcoreFactory.eINSTANCE.createEClass();

    public static void main(String[] args) {
        TestRunner.run(ClassFilterTest.class);
    }

    protected ClassFilter getFixture() {
        return (ClassFilter)this.fixture;
    }

    public void setUp() {
        this.cls = EcoreFactory.eINSTANCE.createEClass();
        this.cls.setName("theClass");
        this.superCls = EcoreFactory.eINSTANCE.createEClass();
        this.superCls.setName("super");
        this.cls.getESuperTypes().add((Object)this.superCls);
        this.inst = new DynamicEObjectImpl(this.cls);
        this.noti = new TestNoti(0, false, false, this.inst);
        this.setFixture(EventManagerFactory.eINSTANCE.createClassFilter(this.superCls));
    }

    public void tearDown() {
        this.cls = null;
        this.inst = null;
        this.noti = null;
        this.setFixture(null);
    }

    public void testMatchesFor__Notification() {
        this.setFixture(EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(this.cls));
        ClassFilterTest.assertTrue((String)"Matches an Event from the given class", (boolean)this.getFixture().matchesFor((Notification)this.noti));
    }

    public void testMatchesFor__SubclassNotification() {
        this.setFixture(EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses(this.superCls));
        ClassFilterTest.assertTrue((String)"Matches an Event from the given class", (boolean)this.getFixture().matchesFor((Notification)this.noti));
    }

    EventFilter getFilterFor(Object f) {
        return EventManagerFactory.eINSTANCE.createClassFilterIncludingSubclasses((EClass)f);
    }

    Object getFilterCriterion1() {
        return this.cls1;
    }

    Object getFilterCriterion2() {
        return this.cls2;
    }

    public Notification[] giveMatchingNotifications() {
        return new Notification[]{new ENotificationImpl((InternalEObject)new DynamicEObjectImpl(this.testCls), 0, null, null, null)};
    }

    public Notification giveNotMatchingNotifcation() {
        EClass otherCls = EcoreFactory.eINSTANCE.createEClass();
        return new ENotificationImpl((InternalEObject)new DynamicEObjectImpl(otherCls), 0, null, null, null);
    }

    public EventFilter giveTestFilter() {
        return EventManagerFactory.eINSTANCE.createClassFilter(this.testCls);
    }

    public class TestNoti
    extends NotificationImpl {
        private Object notifier;

        public TestNoti(int eventType, boolean oldBooleanValue, boolean newBooleanValue, Object noti) {
            super(eventType, oldBooleanValue, newBooleanValue);
            this.notifier = noti;
        }

        public Object getNotifier() {
            return this.notifier;
        }
    }
}

