/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetExpression
extends Expression {
    private Expression varExpression;
    private Expression targetExpression;
    private Identifier varName;

    public LetExpression(Identifier varName, Expression varExpression, Expression target) {
        this.varName = varName;
        this.varExpression = varExpression;
        this.targetExpression = target;
    }

    public Expression getVarExpression() {
        return this.varExpression;
    }

    public Expression getTargetExpression() {
        return this.targetExpression;
    }

    public String getName() {
        return this.varName.getValue();
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Object o = this.varExpression.evaluate(ctx);
        ctx = ctx.cloneWithVariable(new Variable(this.varName.getValue(), o));
        return this.targetExpression.evaluate(ctx);
    }

    @Override
    public Type analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.varExpression == null || this.targetExpression == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.SYNTAX_ERROR, "Syntax error in expression", this));
            return null;
        }
        Type t = this.varExpression.analyze(ctx, issues);
        if (t == null) {
            return null;
        }
        ctx = ctx.cloneWithVariable(new Variable(this.varName.getValue(), t));
        return this.targetExpression.analyze(ctx, issues);
    }

    @Override
    protected String toStringInternal() {
        return "let " + this.varName + "=" + this.varExpression + " : " + this.targetExpression;
    }
}

