/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xpand.internal;

import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xpand2.model.XpandResource;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xtend.typesystem.Type;

public class XpandConverterUtil {
    public static XpandDefinition findDefinition(XpandExecutionContext ctx, String name, Type target, Type[] paramTypes) {
        XpandDefinition def = ctx.findDefinition(name, target, paramTypes);
        if (def == null) {
            def = XpandConverterUtil.guessDefinition(ctx, name, target, paramTypes);
        }
        return def;
    }

    public static XpandDefinition guessDefinition(XpandExecutionContext ctx, String name, Type target, Type[] paramTypes) {
        XpandResource tpl = null;
        tpl = name.indexOf("::") != -1 ? ctx.findTemplate(XpandConverterUtil.withoutLastSegment(name)) : (XpandResource)ctx.currentResource();
        if (tpl == null) {
            return null;
        }
        XpandDefinition[] definitions = tpl.getDefinitions();
        int i = 0;
        while (i < definitions.length) {
            XpandDefinition def = definitions[i];
            if (def.getParams().length == paramTypes.length && (name.equals(def.getQualifiedName()) || name.equals(String.valueOf(XpandConverterUtil.lastSegment(tpl.getFullyQualifiedName())) + "::" + def.getName()) || name.indexOf("::") == -1 && name.equals(XpandConverterUtil.lastSegment(def.getName())))) {
                return def;
            }
            ++i;
        }
        return null;
    }

    public static String withoutLastSegment(String fqn) {
        if (fqn == null || fqn.lastIndexOf("::") == -1) {
            return null;
        }
        return fqn.substring(0, fqn.lastIndexOf("::"));
    }

    public static String lastSegment(String fqn) {
        if (fqn == null) {
            return null;
        }
        if (fqn.lastIndexOf("::") == -1) {
            return fqn;
        }
        return fqn.substring(fqn.lastIndexOf("::") + "::".length());
    }
}

