/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.xsd.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.FunctionDefContext;
import org.eclipse.xtend.backend.common.Property;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.types.AbstractProperty;
import org.eclipse.xtend.backend.types.AbstractType;
import org.eclipse.xtend.backend.types.builtin.ObjectType;
import org.eclipse.xtend.backend.types.builtin.VoidType;
import org.eclipse.xtend.backend.types.emf.EObjectType;
import org.eclipse.xtend.backend.types.xsd.XsdTypesystem;
import org.eclipse.xtend.backend.util.CollectionHelper;
import org.eclipse.xtend.backend.util.ErrorHandler;
import org.eclipse.xtend.backend.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLEClassType
extends AbstractType {
    private final EClass _cls;

    public XMLEClassType(EClass clazz, XsdTypesystem ts) {
        super(XsdTypesystem.getFullyQualifiedName(clazz), XsdTypesystem.getUniqueIdentifier((EClassifier)clazz), XMLEClassType.superTypes(clazz, ts));
        this._cls = clazz;
    }

    public void init(XsdTypesystem xsdTypesystem) {
        this.initProperties(xsdTypesystem);
        this.initOperations(xsdTypesystem);
    }

    private void initProperties(XsdTypesystem xsdTypesystem) {
        for (final EStructuralFeature feature : this._cls.getEStructuralFeatures()) {
            final BackendType t = xsdTypesystem.getTypeForETypedElement((ETypedElement)feature);
            if (feature.isChangeable() && !feature.isUnsettable() && !feature.isDerived()) {
                this.register((Property)new AbstractProperty((BackendType)this, feature.getEType().getInstanceClass(), feature.getName(), true, true){

                    public Object getRaw(ExecutionContext ctx, Object o) {
                        return ((EObject)o).eGet(feature);
                    }

                    public void setRaw(ExecutionContext ctx, Object o, Object newValue) {
                        ((EObject)o).eSet(feature, newValue);
                    }

                    public BackendType getType(BackendTypesystem ts) {
                        return t;
                    }
                }, t);
                continue;
            }
            if (feature.isChangeable() && !feature.isMany() && feature.getEType() instanceof EDataType) {
                EDataType dt = (EDataType)feature.getEType();
                if (ExtendedMetaData.INSTANCE.getMemberTypes(dt).size() == 0) continue;
                BackendType type = xsdTypesystem.findType(feature);
                if (t == null) continue;
                this.register(new QualifiedName("set" + StringHelper.firstUpper((String)feature.getName())), new CompositeTypeAwareSetter(feature, type, xsdTypesystem));
                continue;
            }
            this.register((Property)new AbstractProperty((BackendType)this, feature.getEType().getInstanceClass(), feature.getName(), true, false){

                public Object getRaw(ExecutionContext ctx, Object o) {
                    return ((EObject)o).eGet(feature);
                }

                public BackendType getType(BackendTypesystem ts) {
                    return t;
                }
            }, t);
        }
    }

    private void initOperations(XsdTypesystem xsdTypesystem) {
        for (EOperation op : this._cls.getEOperations()) {
            Class[] paramClasses = new Class[op.getEParameters().size()];
            int i = 0;
            final ArrayList<BackendType> paramTypes = new ArrayList<BackendType>();
            paramTypes.add(xsdTypesystem.getTypeForETypedElement((ETypedElement)op));
            for (EParameter param : op.getEParameters()) {
                paramTypes.add(xsdTypesystem.getTypeForETypedElement((ETypedElement)param));
                paramClasses[i++] = param.getEType().getInstanceClass();
            }
            final BackendType returnType = xsdTypesystem.getTypeForEClassifier(op.getEType());
            try {
                final Method mtd = this._cls.getInstanceClass().getMethod(op.getName(), paramClasses);
                this.register(new QualifiedName(op.getName()), new Function(){

                    public ExpressionBase getGuard() {
                        return null;
                    }

                    public List<? extends BackendType> getParameterTypes() {
                        return paramTypes;
                    }

                    public Object invoke(ExecutionContext ctx, Object[] params) {
                        try {
                            return mtd.invoke(params[0], CollectionHelper.withoutFirst((Object[])params));
                        }
                        catch (Exception e) {
                            ErrorHandler.handle((Exception)e);
                            return null;
                        }
                    }

                    public boolean isCached() {
                        return false;
                    }

                    public FunctionDefContext getFunctionDefContext() {
                        return null;
                    }

                    public void setFunctionDefContext(FunctionDefContext fdc) {
                        throw new UnsupportedOperationException();
                    }

                    public BackendType getReturnType() {
                        return returnType;
                    }
                });
            }
            catch (Exception e) {
                ErrorHandler.handle((Exception)e);
            }
        }
    }

    public Object create() {
        return this._cls.getEPackage().getEFactoryInstance().create(this._cls);
    }

    private static Collection<? extends BackendType> superTypes(EClass eClass, XsdTypesystem ts) {
        HashSet<Object> result = new HashSet<Object>();
        for (EClass ec : eClass.getESuperTypes()) {
            result.add(ts.getTypeForEClassifier((EClassifier)ec));
        }
        result.add(EObjectType.INSTANCE);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._cls == null ? 0 : this._cls.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        XMLEClassType other = (XMLEClassType)((Object)obj);
        return !(this._cls == null ? other._cls != null : !this._cls.equals(other._cls));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CompositeTypeAwareSetter
    implements Function {
        private EStructuralFeature feature;
        private HashMap<BackendType, EDataType> members = new HashMap();
        private XsdTypesystem _ts;
        private FunctionDefContext _fdc;

        public CompositeTypeAwareSetter(EStructuralFeature feature, BackendType type, XsdTypesystem ts) {
            this.feature = feature;
            this._ts = ts;
            ExtendedMetaData em = ExtendedMetaData.INSTANCE;
            this.collectMemberTypes(em, (EDataType)feature.getEType());
        }

        private void collectMemberTypes(ExtendedMetaData em, EDataType type) {
            for (EDataType v : em.getMemberTypes(type)) {
                BackendType k;
                if (!(v instanceof EEnum) && (k = this._ts.getTypeForEClassifier((EClassifier)v)) != null) {
                    this.members.put(k, v);
                }
                this.collectMemberTypes(em, v);
            }
        }

        public Object invoke(ExecutionContext ctx, Object[] params) {
            try {
                Object newValue = params[1];
                ((EObject)params[0]).eSet(this.feature, newValue);
                return params[0];
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }

        public FunctionDefContext getFunctionDefContext() {
            return this._fdc;
        }

        public ExpressionBase getGuard() {
            return null;
        }

        public List<? extends BackendType> getParameterTypes() {
            return Arrays.asList(this, ObjectType.INSTANCE);
        }

        public BackendType getReturnType() {
            return VoidType.INSTANCE;
        }

        public boolean isCached() {
            return false;
        }

        public void setFunctionDefContext(FunctionDefContext fdc) {
            this._fdc = fdc;
        }
    }
}

