/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.uml2.ui;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.resource.UML22UMLResource;
import org.eclipse.xtend.typesystem.uml2.ui.Uml2AdapterLog;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Uml2AdapterPlugin
extends AbstractUIPlugin {
    public static ResourceSet profilesResourceSet = new ResourceSetImpl();
    static final Map<IResource, Profile> fileModels = new HashMap<IResource, Profile>();
    private static Uml2AdapterPlugin plugin;
    private static IResourceChangeListener listener;

    static {
        listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (event.getType() != 1) {
                    return;
                }
                IResourceDelta rootDelta = event.getDelta();
                try {
                    rootDelta.accept((IResourceDeltaVisitor)new ProfileResourceDeltaVisitor());
                }
                catch (CoreException e) {
                    Uml2AdapterLog.logError(e);
                }
            }
        };
    }

    public static final Map<IResource, Profile> getFileModels() {
        return Collections.unmodifiableMap(fileModels);
    }

    public static void removeFileModel(IResource resource) {
        URI uri = URI.createURI((String)resource.getFullPath().toString());
        Resource r = profilesResourceSet.getResource(uri, false);
        if (r != null && r.isLoaded()) {
            r.unload();
        }
        fileModels.remove(resource);
    }

    protected static List<EObject> loadContents(IFile file) {
        try {
            URI uri = URI.createFileURI((String)file.getFullPath().toString());
            Resource r = new ResourceSetImpl().createResource(uri);
            r.load(file.getContents(), Collections.EMPTY_MAP);
            return r.getContents();
        }
        catch (Exception e) {
            Uml2AdapterLog.logError(e);
            return null;
        }
    }

    public Uml2AdapterPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("uml2", UML22UMLResource.Factory.INSTANCE);
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener(listener);
            workspace.getRoot().accept((IResourceVisitor)new ProfileResourceDeltaVisitor());
        }
        catch (CoreException e) {
            Uml2AdapterLog.logError(e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(listener);
    }

    public static Uml2AdapterPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)Uml2AdapterPlugin.getId(), (String)path);
    }

    public static String getId() {
        return Uml2AdapterPlugin.getDefault().getBundle().getSymbolicName();
    }

    static class ProfileResourceDeltaVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        ProfileResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) {
            if (delta.getKind() == 2) {
                Uml2AdapterPlugin.removeFileModel(delta.getResource());
                return true;
            }
            IResource resource = delta.getResource();
            try {
                return this.visit(resource);
            }
            catch (CoreException e) {
                Uml2AdapterLog.logError(e);
                return true;
            }
        }

        public boolean visit(IResource resource) throws CoreException {
            IFile f;
            if (resource instanceof IFile && this.isValidProfile(f = (IFile)resource) && JavaCore.create((IResource)f.getParent()) != null) {
                try {
                    URI uri = URI.createURI((String)f.getFullPath().toString());
                    Profile p = ProfileResourceDeltaVisitor.loadProfile(uri);
                    if (p != null) {
                        fileModels.put((IResource)f, p);
                    }
                }
                catch (Exception e) {
                    Uml2AdapterLog.logError(e);
                }
            }
            return true;
        }

        private boolean isValidProfile(IFile f) {
            return !f.isDerived() && f.isAccessible() && !f.isLinked() && (f.getName().endsWith("profile.uml2") || f.getName().endsWith("profile.uml")) && f.exists();
        }

        public static final synchronized Profile loadProfile(URI uri) {
            Resource r = profilesResourceSet.getResource(uri, false);
            if (r == null) {
                r = profilesResourceSet.getResource(uri, true);
            } else {
                if (r.isLoaded()) {
                    r.unload();
                }
                try {
                    r.load(new HashMap());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            EList c = r.getContents();
            if (c.isEmpty()) {
                return null;
            }
            if (c.get(0) instanceof Profile) {
                Profile p = (Profile)c.get(0);
                URIConverter.URI_MAP.put(URI.createURI((String)uri.lastSegment()), uri);
                return p;
            }
            return null;
        }
    }
}

