/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.types.uml2.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.types.AbstractProperty;
import org.eclipse.xtend.backend.types.AbstractType;
import org.eclipse.xtend.backend.types.builtin.CollectionType;
import org.eclipse.xtend.backend.types.uml2.UmlTypesystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StereotypeType
extends AbstractType {
    private final Stereotype _stereoType;

    public StereotypeType(String name, Stereotype stereoType, UmlTypesystem umlTs) {
        super(name, name, StereotypeType.superTypes(umlTs, stereoType).toArray(new BackendType[0]));
        this._stereoType = stereoType;
        for (StereotypeProperty stp : this.getProperties((BackendType)this, stereoType, umlTs)) {
            this.register((org.eclipse.xtend.backend.common.Property)stp, stp.getType(umlTs));
        }
    }

    private Collection<StereotypeProperty> getProperties(BackendType owningType, Stereotype stereoType, UmlTypesystem umlTs) {
        HashSet<StereotypeProperty> result = new HashSet<StereotypeProperty>();
        for (Property attrib : stereoType.getAttributes()) {
            if (attrib.getName() == null) continue;
            UmlTypesystem.fixName((NamedElement)attrib);
            Type umlType = this.getTypeResolveProxy(attrib);
            if (umlType.getQualifiedName() == null) {
                LogFactory.getLog(owningType.getClass()).error((Object)("qualified name is null for element " + attrib.getQualifiedName()));
                continue;
            }
            CollectionType backendType = attrib.isMultivalued() ? CollectionType.INSTANCE : umlTs.getTypeForStereotypeProperty(umlType);
            result.add(new StereotypeProperty(attrib.getName(), (BackendType)backendType));
        }
        return result;
    }

    private static Collection<BackendType> superTypes(UmlTypesystem umlTs, Stereotype stereoType) {
        ArrayList all = new ArrayList(stereoType.getExtendedMetaclasses());
        all.addAll(stereoType.getSuperClasses());
        ArrayList<BackendType> result = new ArrayList<BackendType>();
        for (Classifier classifier : all) {
            BackendType bt = umlTs.findType(UmlTypesystem.getUniqueIdentifier((NamedElement)classifier));
            if (bt != null) {
                result.add(bt);
                continue;
            }
            result.add(umlTs.getTypeForEClassifier((EClassifier)classifier.eClass()));
        }
        return result;
    }

    private Type getTypeResolveProxy(Property p) {
        Type result = p.getType();
        if (result.eIsProxy()) {
            InternalEObject proxy = (InternalEObject)result;
            URI uri = proxy.eProxyURI();
            result = (Type)EcoreUtil.resolve((EObject)proxy, (EObject)p);
            if (result.eIsProxy()) {
                throw new IllegalStateException("Couldn't resolve proxy under " + uri);
            }
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._stereoType == null ? 0 : this._stereoType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        StereotypeType other = (StereotypeType)((Object)obj);
        return !(this._stereoType == null ? other._stereoType != null : !this._stereoType.equals(other._stereoType));
    }

    private final class StereotypeProperty
    extends AbstractProperty {
        private final BackendType _type;

        public StereotypeProperty(String name, BackendType type) {
            super((BackendType)StereotypeType.this, Object.class, name, true, false);
            this._type = type;
        }

        public Object getRaw(ExecutionContext ctx, Object target) {
            if (target instanceof Element) {
                Element ele = (Element)target;
                for (Stereotype st : ele.getAppliedStereotypes()) {
                    Object dynValue;
                    if (!this.isStereoTypeAssignable(st, StereotypeType.this._stereoType)) continue;
                    Object value = ele.getValue(st, this.getName());
                    if (value instanceof EList) {
                        EList eList = (EList)value;
                        ArrayList<Object> values = new ArrayList<Object>();
                        for (Object dynObject : eList) {
                            Object dynValue2 = this.getDynamicValue(dynObject);
                            if (dynValue2 == null) continue;
                            values.add(dynValue2);
                        }
                        if (!values.isEmpty()) {
                            return values;
                        }
                    } else if (value instanceof EObject && (dynValue = this.getDynamicValue(value)) != null) {
                        return dynValue;
                    }
                    return value;
                }
            }
            throw new IllegalArgumentException("uml2 Element expected but was " + target.getClass().getName());
        }

        public BackendType getType(BackendTypesystem ts) {
            return this._type;
        }

        private Object getDynamicValue(Object value) {
            EObject dynObject;
            EClass dynClass;
            EStructuralFeature baseClassFeature;
            if (value instanceof EObject && (baseClassFeature = (dynClass = (dynObject = (EObject)value).eClass()).getEStructuralFeature("base_Class")) != null) {
                return dynObject.eGet(baseClassFeature, true);
            }
            return null;
        }

        private boolean isStereoTypeAssignable(Stereotype st1, Stereotype st2) {
            if (st1.getQualifiedName().equals(st2.getQualifiedName())) {
                return true;
            }
            EList gs = st1.getGeneralizations();
            for (Generalization g : gs) {
                if (!(g.getGeneral() instanceof Stereotype) || !this.isStereoTypeAssignable((Stereotype)g.getGeneral(), st2)) continue;
                return true;
            }
            return false;
        }
    }
}

