/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.ConfigurationException;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEnd;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEndFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageContributor {
    private static final Log _log = LogFactory.getLog(LanguageContributor.class);
    public static final LanguageContributor INSTANCE = new LanguageContributor();
    private final Map<String, LanguageSpecificMiddleEndFactory> _middleEndContributions = new HashMap<String, LanguageSpecificMiddleEndFactory>();

    private LanguageContributor() {
    }

    public void addLanguageContribution(Class<? extends LanguageSpecificMiddleEndFactory> middleEndFactoryClass) throws ConfigurationException {
        try {
            LanguageSpecificMiddleEndFactory factory = middleEndFactoryClass.newInstance();
            this._middleEndContributions.put(factory.getName(), factory);
        }
        catch (InstantiationException e) {
            throw new ConfigurationException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public Collection<LanguageSpecificMiddleEndFactory> getLanguageContributions() {
        return this._middleEndContributions.values();
    }

    public LanguageSpecificMiddleEndFactory getLanguageContributionByName(String middleEndName) {
        return this._middleEndContributions.get(middleEndName);
    }

    public List<LanguageSpecificMiddleEnd> getFreshMiddleEnds(Map<Class<?>, Object> specificParams) {
        ArrayList<LanguageSpecificMiddleEnd> result = new ArrayList<LanguageSpecificMiddleEnd>();
        for (LanguageSpecificMiddleEndFactory factory : this._middleEndContributions.values()) {
            try {
                result.add(factory.create(specificParams.get(factory.getClass())));
            }
            catch (IllegalArgumentException exc) {
                _log.debug((Object)("middle end implementation " + factory.getName() + " says it is not available: " + exc.getMessage()));
            }
        }
        return result;
    }
}

