/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.expr;

import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.SourcePos;

public final class IfExpression
extends ExpressionBase {
    private final ExpressionBase _cond;
    private final ExpressionBase _if;
    private final ExpressionBase _else;

    public IfExpression(ExpressionBase cond, ExpressionBase ifResult, ExpressionBase elseResult, SourcePos sourcePos) {
        super(sourcePos);
        this._cond = cond;
        this._if = ifResult;
        this._else = elseResult;
    }

    public ExpressionBase getCondition() {
        return this._cond;
    }

    public ExpressionBase getIfPart() {
        return this._if;
    }

    public ExpressionBase getElsePart() {
        return this._else;
    }

    protected Object evaluateInternal(ExecutionContext ctx) {
        Object cond = this._cond.evaluate(ctx);
        if (cond == null) {
            ctx.logNullDeRef(this.getPos());
            return null;
        }
        if (Boolean.TRUE.equals(cond)) {
            return this._if.evaluate(ctx);
        }
        return this._else.evaluate(ctx);
    }
}

