/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.aop.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend.backend.aop.AdvisedFunction;
import org.eclipse.xtend.backend.aop.AroundAdvice;
import org.eclipse.xtend.backend.aop.internal.AdviceScopeCounter;
import org.eclipse.xtend.backend.common.AdviceContext;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.util.DoubleKeyCache;
import org.eclipse.xtend.backend.util.ObjectWrapper;
import org.eclipse.xtend.backend.util.Triplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AdviceContextImpl
implements AdviceContext {
    private final List<AroundAdvice> _advice = new ArrayList<AroundAdvice>();
    private int _numAdviceInScope = 0;
    private final AdviceScopeCounter _scopeCounter = new AdviceScopeCounter(){

        public void enterAdvice() {
            AdviceContextImpl adviceContextImpl = AdviceContextImpl.this;
            adviceContextImpl._numAdviceInScope = adviceContextImpl._numAdviceInScope + 1;
        }

        public void leaveAdvice() {
            AdviceContextImpl adviceContextImpl = AdviceContextImpl.this;
            adviceContextImpl._numAdviceInScope = adviceContextImpl._numAdviceInScope - 1;
        }

        public boolean isWithinAdvice() {
            return AdviceContextImpl.this._numAdviceInScope > 0;
        }
    };
    private final DoubleKeyCache<QualifiedName, Function, AdvisedFunction> _advisedFunctionCache = new DoubleKeyCache<QualifiedName, Function, AdvisedFunction>(){

        @Override
        protected AdvisedFunction create(QualifiedName functionName, Function f) {
            ArrayList<AroundAdvice> applicableAdvice = new ArrayList<AroundAdvice>();
            for (AroundAdvice advice : AdviceContextImpl.this._advice) {
                if (!advice.getPointcut().matches(functionName, f)) continue;
                applicableAdvice.add(advice);
            }
            return new AdvisedFunction(functionName, f, applicableAdvice, AdviceContextImpl.this._scopeCounter);
        }
    };
    private final Map<Triplet<Function, AroundAdvice, List<?>>, ObjectWrapper> _resultCache;

    public AdviceContextImpl() {
        this(new HashMap());
    }

    private AdviceContextImpl(Map<Triplet<Function, AroundAdvice, List<?>>, ObjectWrapper> resultCache) {
        this._resultCache = resultCache;
    }

    @Override
    public AdviceContextImpl copyWithAdvice(AroundAdvice advice) {
        AdviceContextImpl result = new AdviceContextImpl(this._resultCache);
        result._advice.addAll(this._advice);
        result._advice.add(advice);
        return result;
    }

    @Override
    public AdvisedFunction getAdvice(QualifiedName functionName, Function f) {
        if (this._scopeCounter.isWithinAdvice()) {
            return this.unadvisedFunction(functionName, f);
        }
        return this._advisedFunctionCache.get(functionName, f);
    }

    private AdvisedFunction unadvisedFunction(QualifiedName functionName, Function f) {
        return new AdvisedFunction(functionName, f, Collections.EMPTY_LIST, this._scopeCounter);
    }

    @Override
    public Map<Triplet<Function, AroundAdvice, List<?>>, ObjectWrapper> getResultCache() {
        return this._resultCache;
    }
}

