/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.internal.xtend.expression.ast.BooleanLiteral;
import org.eclipse.internal.xtend.expression.ast.BooleanOperation;
import org.eclipse.internal.xtend.expression.ast.Case;
import org.eclipse.internal.xtend.expression.ast.Cast;
import org.eclipse.internal.xtend.expression.ast.ChainExpression;
import org.eclipse.internal.xtend.expression.ast.CollectionExpression;
import org.eclipse.internal.xtend.expression.ast.ConstructorCallExpression;
import org.eclipse.internal.xtend.expression.ast.DeclaredParameter;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.GlobalVarExpression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.IfExpression;
import org.eclipse.internal.xtend.expression.ast.IntegerLiteral;
import org.eclipse.internal.xtend.expression.ast.LetExpression;
import org.eclipse.internal.xtend.expression.ast.ListLiteral;
import org.eclipse.internal.xtend.expression.ast.NullLiteral;
import org.eclipse.internal.xtend.expression.ast.OperationCall;
import org.eclipse.internal.xtend.expression.ast.RealLiteral;
import org.eclipse.internal.xtend.expression.ast.StringLiteral;
import org.eclipse.internal.xtend.expression.ast.SwitchExpression;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.internal.xtend.expression.ast.TypeSelectExpression;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFactory {
    private String fileName;

    public ExpressionFactory(String string) {
        this.fileName = string;
    }

    public ExpressionFactory() {
        this.fileName = "nofile";
    }

    public Identifier createIdentifier(String text) {
        return this.handle(new Identifier(text));
    }

    public StringLiteral createStringLiteral(Identifier t) {
        return this.handle(new StringLiteral(t));
    }

    public IntegerLiteral createIntegerLiteral(Identifier t) {
        return this.handle(new IntegerLiteral(t));
    }

    public BooleanLiteral createBooleanLiteral(Identifier t) {
        return this.handle(new BooleanLiteral(t));
    }

    public NullLiteral createNullLiteral(Identifier t) {
        return this.handle(new NullLiteral(t));
    }

    public ListLiteral createListLiteral(List<Expression> paramExpr) {
        if (paramExpr == null) {
            paramExpr = new ArrayList<Expression>();
        }
        return this.handle(new ListLiteral(paramExpr.toArray(new Expression[paramExpr.size()])));
    }

    public FeatureCall createFeatureCall(Identifier name, Expression target) {
        return this.handle(new FeatureCall(name, target));
    }

    public OperationCall createOperationCall(Identifier name, Expression singleParam) {
        return this.handle(new OperationCall(name, singleParam, new Expression[0]));
    }

    public OperationCall createOperationCall(Identifier name, List<Expression> parameterExpressions) {
        if (parameterExpressions == null) {
            parameterExpressions = new ArrayList<Expression>();
        }
        Expression[] params = parameterExpressions.toArray(new Expression[parameterExpressions.size()]);
        return this.handle(new OperationCall(name, null, params));
    }

    public Expression createBinaryOperation(Identifier name, Expression left, Expression right) {
        return this.handle(new OperationCall(name, left, right));
    }

    public IfExpression createIf(Expression cond, Expression then, Expression elseExpr) {
        return this.handle(new IfExpression(cond, then, elseExpr));
    }

    public CollectionExpression createCollectionExpression(Identifier opName, Identifier elementName, Expression closure) {
        return this.handle(new CollectionExpression(opName, elementName, closure));
    }

    public DeclaredParameter createDeclaredParameter(Identifier type, Identifier name) {
        return this.handle(new DeclaredParameter(type, name));
    }

    public Expression createCast(Identifier t, Expression e) {
        return this.handle(new Cast(t, e));
    }

    protected <T extends SyntaxElement> T handle(T expr) {
        expr.setFileName(this.fileName);
        return expr;
    }

    protected SyntaxElement handle(ExtensionFile expr) {
        expr.setFileName(this.fileName);
        expr.setFullyQualifiedName(this.fileName);
        return expr;
    }

    public Case createCase(Expression cond, Expression then) {
        return this.handle(new Case(cond, then));
    }

    public SwitchExpression createSwitchExpression(Expression switchExpr, List<Case> cases, Expression defaultExpr) {
        return this.handle(new SwitchExpression(switchExpr, this.nonNull(cases), defaultExpr));
    }

    public ChainExpression createChainExpression(Expression head, Expression next) {
        return this.handle(new ChainExpression(head, next));
    }

    public RealLiteral createRealLiteral(Identifier lit) {
        return this.handle(new RealLiteral(lit));
    }

    public FeatureCall createTypeSelectExpression(Identifier id, Identifier ident) {
        return this.handle(new TypeSelectExpression(id, ident));
    }

    public BooleanOperation createBooleanOperation(Identifier name, Expression e, Expression r) {
        return this.handle(new BooleanOperation(name, e, r));
    }

    public LetExpression createLetExpression(Identifier v, Expression varExpr, Expression target) {
        return this.handle(new LetExpression(v, varExpr, target));
    }

    public Expression createConstructorCall(Identifier type) {
        return this.handle(new ConstructorCallExpression(type));
    }

    public GlobalVarExpression createGlobalVarExpression(Identifier name) {
        return this.handle(new GlobalVarExpression(name));
    }

    public Expression createParanthesizedExpression(Expression x) {
        return x;
    }

    protected <T> List<T> nonNull(List<T> l) {
        if (l == null) {
            return new ArrayList();
        }
        Iterator<T> iter = l.iterator();
        while (iter.hasNext()) {
            T x = iter.next();
            if (x != null) continue;
            iter.remove();
        }
        return l;
    }
}

