/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.parser.ast;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jet.core.parser.IJETParser;
import org.eclipse.jet.core.parser.ITagLibraryResolver;
import org.eclipse.jet.core.parser.ITemplateInput;
import org.eclipse.jet.core.parser.ITemplateResolver;
import org.eclipse.jet.core.parser.RecursiveIncludeException;
import org.eclipse.jet.internal.core.parser.IJETParser2;
import org.eclipse.jet.internal.core.parser.InternalJET1Parser;
import org.eclipse.jet.internal.core.parser.InternalJET2Parser;
import org.eclipse.jet.taglib.TagLibrary;

public final class JETASTParser
implements IJETParser,
IJETParser2 {
    private static final ITemplateResolver nullTemplateResolver = new ITemplateResolver(){

        public URI[] getBaseLocations() {
            try {
                URI nullURI = new URI("");
                return new URI[]{nullURI};
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        public ITemplateInput getIncludedInput(String templatePath, ITemplateInput[] activeInputs) throws RecursiveIncludeException {
            return null;
        }

        public ITemplateInput getInput(String templatePath) {
            return null;
        }
    };
    private final IJETParser parser;

    private JETASTParser(Builder builder) {
        Map predefinedTagLibraries;
        ITemplateResolver templateResolver = builder.templateResolver == null ? nullTemplateResolver : builder.templateResolver;
        Map map = predefinedTagLibraries = builder.predefinedTagLibraries == null ? Collections.EMPTY_MAP : builder.predefinedTagLibraries;
        this.parser = builder.jetSpec == 2 ? new InternalJET2Parser(templateResolver, builder.tagLibraryResolver == null ? new NullTagLibraryResolver() : builder.tagLibraryResolver, predefinedTagLibraries, builder.enableEmbeddedExpressions) : new InternalJET1Parser(templateResolver);
    }

    public Object parse(String templatePath) {
        return this.parser.parse(templatePath);
    }

    public Object parse(char[] template) {
        return this.parser.parse(template);
    }

    public Object parse(char[] template, String templatePath) {
        if (this.parser instanceof IJETParser2) {
            return ((IJETParser2)this.parser).parse(template, templatePath);
        }
        return this.parser.parse(template);
    }

    /* synthetic */ JETASTParser(Builder builder, JETASTParser jETASTParser) {
        this(builder);
    }

    public static final class Builder {
        ITemplateResolver templateResolver = null;
        Map predefinedTagLibraries;
        ITagLibraryResolver tagLibraryResolver;
        final int jetSpec;
        boolean enableEmbeddedExpressions = false;

        public Builder(int jetSpec) {
            if (jetSpec != 1 && jetSpec != 2) {
                throw new IllegalArgumentException();
            }
            this.jetSpec = jetSpec;
        }

        public Builder templateResolver(ITemplateResolver templateResolver) {
            if (templateResolver == null) {
                throw new NullPointerException();
            }
            this.templateResolver = templateResolver;
            return this;
        }

        public Builder predefinedTagLibraries(Map predefinedTagLibraries) {
            if (predefinedTagLibraries == null) {
                throw new NullPointerException();
            }
            this.predefinedTagLibraries = predefinedTagLibraries;
            return this;
        }

        public Builder tagLibraryResolver(ITagLibraryResolver tagLibraryResolver) {
            this.tagLibraryResolver = tagLibraryResolver;
            return this;
        }

        public Builder enableEmbeddedExpressions(boolean enableEmbeddedExpressions) {
            this.enableEmbeddedExpressions = enableEmbeddedExpressions;
            return this;
        }

        public JETASTParser build() {
            return new JETASTParser(this, null);
        }
    }

    private static final class NullTagLibraryResolver
    implements ITagLibraryResolver {
        private NullTagLibraryResolver() {
        }

        public TagLibrary getLibrary(String tagLibraryID) {
            return null;
        }
    }
}

