/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ui.interpreter.internal.debug;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.ui.interpreter.InterpreterPlugin;
import org.eclipse.acceleo.ui.interpreter.internal.InterpreterMessages;
import org.eclipse.acceleo.ui.interpreter.view.InterpreterView;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class AddVariablesDebugViewActionDelegate
implements IViewActionDelegate {
    private List<Object> currentVariablesValues = new ArrayList<Object>();

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List variables = structuredSelection.toList();
            this.currentVariablesValues.clear();
            for (Object variable : variables) {
                EObject variableEObject = null;
                variableEObject = variable instanceof EObject ? (EObject)variable : (variable instanceof IAdaptable ? (EObject)((IAdaptable)variable).getAdapter(EObject.class) : (EObject)Platform.getAdapterManager().getAdapter(variable, EObject.class));
                if (variableEObject != null) {
                    this.currentVariablesValues.add(variableEObject);
                    continue;
                }
                this.currentVariablesValues.add(variable);
            }
        }
    }

    public void run(IAction action) {
        if (this.currentVariablesValues.size() > 0) {
            ArrayList<Object> variables = new ArrayList<Object>(this.currentVariablesValues);
            IViewReference interpreterViewReference = null;
            IViewReference[] viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
            IViewReference[] iViewReferenceArray = viewReferences;
            int n = viewReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference iViewReference = iViewReferenceArray[n2];
                if ("org.eclipse.acceleo.ui.interpreter.view".equals(iViewReference.getId())) {
                    interpreterViewReference = iViewReference;
                }
                ++n2;
            }
            IViewPart interpreterViewPart = null;
            if (interpreterViewReference == null) {
                try {
                    interpreterViewPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.acceleo.ui.interpreter.view");
                }
                catch (PartInitException e) {
                    InterpreterPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter", e.getMessage()));
                }
            } else {
                IWorkbenchPart part = interpreterViewReference.getPart(true);
                if (part instanceof IViewPart) {
                    interpreterViewPart = (IViewPart)part;
                }
            }
            if (interpreterViewPart != null) {
                interpreterViewPart.setFocus();
            } else {
                InterpreterPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ui.interpreter", InterpreterMessages.getString("AddVariablesDebug.InterpreterViewNotFound")));
            }
            if (interpreterViewPart instanceof InterpreterView) {
                InterpreterView interpreterView = (InterpreterView)interpreterViewPart;
                if (!interpreterView.isVariableVisible()) {
                    interpreterView.toggleVariableVisibility();
                }
                for (Object e : variables) {
                    interpreterView.addVariables(e);
                }
            }
        }
    }
}

