/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.service.properties;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.acceleo.engine.service.AcceleoService;
import org.eclipse.acceleo.engine.service.properties.AbstractAcceleoPropertiesLoaderService;
import org.eclipse.emf.common.EMFPlugin;
import org.osgi.framework.Bundle;

public class BundleAcceleoPropertiesLoaderService
extends AbstractAcceleoPropertiesLoaderService {
    private Bundle bundle;

    public BundleAcceleoPropertiesLoaderService(AcceleoService acceleoService, Bundle bundle) {
        this.acceleoService = acceleoService;
        this.bundle = bundle;
    }

    protected Properties alternatePropertiesLoading(String filepath) {
        Properties properties = new Properties();
        if (EMFPlugin.IS_ECLIPSE_RUNNING && this.bundle != null) {
            try {
                URL resource = this.bundle.getResource(filepath);
                if (resource != null) {
                    properties.load(resource.openStream());
                } else if (filepath != null && !filepath.endsWith(".properties")) {
                    String filename = filepath;
                    if (filename.contains(".")) {
                        filename = filename.substring(filename.lastIndexOf(".") + 1);
                    }
                    filename = String.valueOf(filename) + ".properties";
                    Enumeration entries = this.bundle.findEntries("/", filename, true);
                    Object firstEntry = null;
                    if (entries.hasMoreElements()) {
                        firstEntry = entries.nextElement();
                    }
                    if (firstEntry instanceof URL) {
                        properties.load(((URL)firstEntry).openStream());
                    }
                }
            }
            catch (IOException e) {
                return null;
            }
        }
        return properties;
    }
}

