/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.rules;

import org.eclipse.acceleo.internal.ide.ui.editors.template.rules.ISequenceRule;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class SequenceRule
implements ISequenceRule {
    protected String[] words;
    protected IToken token;

    public SequenceRule(String[] words) {
        this(words, (IToken)new Token((Object)"__dftl_partition_content_type"));
    }

    public SequenceRule(String[] words, IToken token) {
        this.words = words;
        this.token = token;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.read(scanner) > 0) {
            return this.token;
        }
        return Token.UNDEFINED;
    }

    public int read(ICharacterScanner scanner) {
        if (this.words == null || this.words.length == 0) {
            return 0;
        }
        int shift = 0;
        Boolean valid = null;
        int i = 0;
        while (i < this.words.length) {
            int n = this.readWord(this.words[i], scanner);
            if (n == 0) {
                valid = Boolean.FALSE;
                break;
            }
            shift += n;
            if (i + 1 < this.words.length) {
                shift += this.readWhitespace(scanner);
            }
            ++i;
        }
        if (valid != null) {
            while (shift > 0) {
                scanner.unread();
                --shift;
            }
        }
        return shift;
    }

    private int readWord(String word, ICharacterScanner scanner) {
        int i = 0;
        while (i < word.length()) {
            int c = scanner.read();
            boolean stop = c == -1 || c != word.charAt(i);
            boolean bl = stop = stop || i + 1 == word.length() && Character.isJavaIdentifierPart(word.charAt(i)) && !this.nextIsNotIdentifierPart(scanner);
            if (stop) {
                int shift = i;
                while (shift >= 0) {
                    scanner.unread();
                    --shift;
                }
                return 0;
            }
            ++i;
        }
        return word.length();
    }

    private boolean nextIsNotIdentifierPart(ICharacterScanner scanner) {
        int c = scanner.read();
        boolean result = c == -1 || !Character.isJavaIdentifierPart(c);
        scanner.unread();
        return result;
    }

    private int readWhitespace(ICharacterScanner scanner) {
        int c = scanner.read();
        int n = 0;
        while (c != -1 && Character.isWhitespace(c)) {
            ++n;
            c = scanner.read();
        }
        scanner.unread();
        return n;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        return this.evaluate(scanner);
    }
}

