/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.ide.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.ide.ui.resources.AcceleoProject;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AcceleoUIActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.acceleo.ide.ui";
    private static AcceleoUIActivator plugin;
    private Map<String, Image> imageMap = new HashMap<String, Image>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        AcceleoProject.getAllPlatformPluginOutputFiles();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        for (Image image : this.imageMap.values()) {
            image.dispose();
        }
        this.imageMap.clear();
    }

    public static AcceleoUIActivator getDefault() {
        return plugin;
    }

    public Image getImage(String path) {
        ImageDescriptor descriptor;
        Image result = this.imageMap.get(path);
        if (result == null && (descriptor = AcceleoUIActivator.getImageDescriptor(path)) != null) {
            result = descriptor.createImage();
            this.imageMap.put(path, result);
        }
        return result;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AcceleoUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static void log(Exception exception, boolean blocker) {
        int severity = 2;
        if (blocker) {
            severity = 4;
        }
        ILog log = AcceleoUIActivator.getDefault().getLog();
        log.log((IStatus)new Status(severity, PLUGIN_ID, exception.getMessage(), (Throwable)exception));
    }
}

