/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.rt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.codegen.gmfgen.ElementType;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.MetamodelType;
import org.eclipse.gmf.codegen.gmfgen.SpecializationType;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.common.codegen.XpandTextEmitter;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.util.BundleResourceManager;
import org.eclipse.gmf.mappings.Constraint;
import org.eclipse.gmf.mappings.ElementInitializer;
import org.eclipse.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.gmf.mappings.FeatureValueSpec;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.Language;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.ValueExpression;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.Utils;
import org.eclipse.gmf.tests.gef.AbstractDiagramEditorTest;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.GenProjectSetup;
import org.eclipse.gmf.tests.setup.GeneratedDiagramPlugin;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.MapSetup;
import org.eclipse.gmf.tests.setup.RuntimeBasedGeneratorConfiguration;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.gmf.tests.setup.ToolDefSource;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditHelpersTest
extends AbstractDiagramEditorTest {
    private static final String BEFORE_PREFIX = "before";
    private static final String AFTER_PREFIX = "after";
    private static final String MARKER_COMMAND_LABEL = "MarkerCommand";

    public EditHelpersTest(String name) {
        super(name, new RuntimeBasedGeneratorConfiguration());
    }

    public void testSingleEditHelperAdviceNode() {
        EditHelpersTest.assertTrue((boolean)(this.getSetup().getGenModel().getNodeA().getElementType() instanceof MetamodelType));
        Command command = this.getSetNewTopLeveNodeNameCommand(this.getSetup().getGenModel().getNodeA(), this.getSetup().getDomainModel().getNodeA().getNameAttr().getName());
        Collection<IUndoableOperation> allMarkerCommands = this.getAllMarkerCommands(command);
        Collection<IUndoableOperation> beforeCommands = this.getBeforeCommands(allMarkerCommands);
        Collection<IUndoableOperation> afterCommands = this.getAfterCommands(allMarkerCommands);
        EditHelpersTest.assertTrue((beforeCommands.size() == 1 ? 1 : 0) != 0);
        EditHelpersTest.assertTrue((this.getEditHelperVisualID(beforeCommands.iterator().next()) == this.getSetup().getGenModel().getNodeA().getVisualID() ? 1 : 0) != 0);
        EditHelpersTest.assertTrue((afterCommands.size() == 1 ? 1 : 0) != 0);
        EditHelpersTest.assertTrue((this.getEditHelperVisualID(afterCommands.iterator().next()) == this.getSetup().getGenModel().getNodeA().getVisualID() ? 1 : 0) != 0);
    }

    public void testTwoEditHelperAdvicesNode() {
        EditHelpersTest.assertTrue((boolean)(this.getSetup().getGenModel().getNodeB().getElementType() instanceof SpecializationType));
        Command command = this.getSetNewTopLeveNodeNameCommand(this.getSetup().getGenModel().getNodeB(), this.getSetup().getDomainModel().getNodeB().getNameAttr().getName());
        Collection<IUndoableOperation> allMarkerCommands = this.getAllMarkerCommands(command);
        Collection<IUndoableOperation> beforeCommands = this.getBeforeCommands(allMarkerCommands);
        Collection<IUndoableOperation> afterCommands = this.getAfterCommands(allMarkerCommands);
        EditHelpersTest.assertTrue((beforeCommands.size() == 2 ? 1 : 0) != 0);
        EditHelpersTest.assertTrue((boolean)this.hasCommand(beforeCommands, this.getSetup().getGenModel().getNodeA().getVisualID()));
        EditHelpersTest.assertTrue((boolean)this.hasCommand(beforeCommands, this.getSetup().getGenModel().getNodeB().getVisualID()));
        EditHelpersTest.assertTrue((afterCommands.size() == 2 ? 1 : 0) != 0);
        EditHelpersTest.assertTrue((boolean)this.hasCommand(afterCommands, this.getSetup().getGenModel().getNodeA().getVisualID()));
        EditHelpersTest.assertTrue((boolean)this.hasCommand(afterCommands, this.getSetup().getGenModel().getNodeB().getVisualID()));
    }

    @Override
    protected Diagram createDiagramView(EObject domainElement, GeneratedDiagramPlugin genPlugin) {
        return RuntimeBasedGeneratorConfiguration.createDiagram(domainElement, genPlugin);
    }

    private boolean hasCommand(Collection<IUndoableOperation> beforeCommands, int visualID) {
        for (IUndoableOperation operation : beforeCommands) {
            if (this.getEditHelperVisualID(operation) != visualID) continue;
            return true;
        }
        return false;
    }

    private Command getSetNewTopLeveNodeNameCommand(GenNode genNode, String nameAttribute) {
        Node node = this.createNode((GenCommonBase)genNode, (View)this.getDiagram());
        EditHelpersTest.assertNotNull((Object)node);
        EditPart nodeEditPart = this.getViewerConfiguration().findEditPart((View)node);
        EditHelpersTest.assertNotNull((Object)nodeEditPart);
        EObject nodeElement = node.getElement();
        SetRequest setReq = new SetRequest(nodeElement, nodeElement.eClass().getEStructuralFeature(nameAttribute), (Object)"newName");
        Command command = nodeEditPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)setReq));
        EditHelpersTest.assertNotNull((Object)command);
        EditHelpersTest.assertTrue((boolean)command.canExecute());
        return command;
    }

    private Collection<IUndoableOperation> getAllMarkerCommands(Command command) {
        if (command instanceof CompoundCommand) {
            ArrayList<IUndoableOperation> result = new ArrayList<IUndoableOperation>();
            for (Object object : ((CompoundCommand)command).getCommands()) {
                result.addAll(this.getAllMarkerCommands((Command)object));
            }
            return result;
        }
        if (command instanceof ICommandProxy) {
            ICommandProxy commandProxy = (ICommandProxy)command;
            return this.getAllMarkerCommands((IUndoableOperation)commandProxy.getICommand());
        }
        return Collections.emptyList();
    }

    private Collection<IUndoableOperation> getAllMarkerCommands(IUndoableOperation operation) {
        if (operation instanceof ICompositeCommand) {
            ICompositeCommand compositeCommand = (ICompositeCommand)operation;
            ArrayList<IUndoableOperation> result = new ArrayList<IUndoableOperation>();
            Iterator it = compositeCommand.iterator();
            while (it.hasNext()) {
                result.addAll(this.getAllMarkerCommands((IUndoableOperation)it.next()));
            }
            return result;
        }
        if (this.isMarkerCommand(operation)) {
            return Collections.singletonList(operation);
        }
        return Collections.emptyList();
    }

    private boolean isMarkerCommand(IUndoableOperation operation) {
        String label = operation.getLabel();
        return label != null && label.indexOf(MARKER_COMMAND_LABEL) > -1;
    }

    private Collection<IUndoableOperation> getBeforeCommands(Collection<IUndoableOperation> markerCommands) {
        ArrayList<IUndoableOperation> result = new ArrayList<IUndoableOperation>();
        for (IUndoableOperation command : markerCommands) {
            if (!this.isBeforeMarkerCommand(command)) continue;
            result.add(command);
        }
        return result;
    }

    private Collection<IUndoableOperation> getAfterCommands(Collection<IUndoableOperation> markerCommands) {
        ArrayList<IUndoableOperation> result = new ArrayList<IUndoableOperation>();
        for (IUndoableOperation command : markerCommands) {
            if (!this.isAfterMarkerCommand(command)) continue;
            result.add(command);
        }
        return result;
    }

    private boolean isBeforeMarkerCommand(IUndoableOperation operation) {
        EditHelpersTest.assertTrue((String)"Should be marker operation", (boolean)this.isMarkerCommand(operation));
        String label = operation.getLabel();
        return BEFORE_PREFIX.equals(label.substring(0, label.indexOf(MARKER_COMMAND_LABEL)));
    }

    private boolean isAfterMarkerCommand(IUndoableOperation operation) {
        EditHelpersTest.assertTrue((String)"Should be marker operation", (boolean)this.isMarkerCommand(operation));
        String label = operation.getLabel();
        return AFTER_PREFIX.equals(label.substring(0, label.indexOf(MARKER_COMMAND_LABEL)));
    }

    private int getEditHelperVisualID(IUndoableOperation operation) {
        EditHelpersTest.assertTrue((String)"Should be marker operation", (boolean)this.isMarkerCommand(operation));
        String label = operation.getLabel();
        return Integer.valueOf(label.substring(label.indexOf(MARKER_COMMAND_LABEL) + MARKER_COMMAND_LABEL.length()));
    }

    private static final class EditHelpersMapSetup
    extends MapSetup {
        private EditHelpersMapSetup() {
        }

        public MapSetup init(DiaDefSource ddSource, DomainModelSource domainSource, ToolDefSource toolDef) {
            super.init(ddSource, domainSource, toolDef);
            this.addConstraint(this.getNodeA(), "nodeName2.oclIsUndefined()");
            this.addNameInitializer(this.getNodeA(), (EStructuralFeature)domainSource.getNodeA().getNameAttr(), "'name'");
            this.addConstraint(this.getNodeB(), "nodeName1.oclIsUndefined()");
            this.addNameInitializer(this.getNodeB(), (EStructuralFeature)domainSource.getNodeB().getNameAttr(), "'name'");
            return this;
        }

        private void addConstraint(NodeMapping node, String body) {
            node.setDomainSpecialization(GMFMapFactory.eINSTANCE.createConstraint());
            node.getDomainSpecialization().setLanguage(Language.OCL_LITERAL);
            node.getDomainSpecialization().setBody(body);
        }

        private void addNameInitializer(NodeMapping node, EStructuralFeature feature, String value) {
            FeatureSeqInitializer root = GMFMapFactory.eINSTANCE.createFeatureSeqInitializer();
            node.setDomainInitializer((ElementInitializer)root);
            FeatureValueSpec nameSpecification = GMFMapFactory.eINSTANCE.createFeatureValueSpec();
            root.getInitializers().add((Object)nameSpecification);
            nameSpecification.setFeature(feature);
            Constraint valueExpr = GMFMapFactory.eINSTANCE.createConstraint();
            nameSpecification.setValue((ValueExpression)valueExpr);
            valueExpr.setBody(value);
            valueExpr.setLanguage(Language.OCL_LITERAL);
        }
    }

    private static final class EditHelpersModelSource
    implements DomainModelSource {
        private EClass myDiagramElement;
        private EPackage myPackage = EcoreFactory.eINSTANCE.createEPackage();
        private DomainModelSource.NodeData myNode1;
        private DomainModelSource.LinkData myClassLink;
        private DomainModelSource.NodeData myNode2;
        private EReference myRefLink;

        private EditHelpersModelSource() {
            this.myPackage.setName("eh");
            this.myPackage.setNsPrefix("sampleEH");
            Calendar c = Calendar.getInstance();
            this.myPackage.setNsURI("uri://eclipse/gmf/tests/sample/eh/" + c.get(11) + '/' + c.get(12) + '/');
            this.myDiagramElement = EcoreFactory.eINSTANCE.createEClass();
            this.myDiagramElement.setName("DiagramElement");
            this.myPackage.getEClassifiers().add((Object)this.myDiagramElement);
            EClass node = EcoreFactory.eINSTANCE.createEClass();
            node.setName("Node");
            this.myPackage.getEClassifiers().add((Object)node);
            EAttribute node1Name = EcoreFactory.eINSTANCE.createEAttribute();
            node1Name.setName("nodeName1");
            node1Name.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
            node.getEStructuralFeatures().add((Object)node1Name);
            EAttribute node2Name = EcoreFactory.eINSTANCE.createEAttribute();
            node2Name.setName("nodeName2");
            node2Name.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
            node.getEStructuralFeatures().add((Object)node2Name);
            EReference nodeContainment = EcoreFactory.eINSTANCE.createEReference();
            nodeContainment.setName("nodeContainment");
            nodeContainment.setContainment(true);
            nodeContainment.setUpperBound(-1);
            nodeContainment.setEType((EClassifier)node);
            this.myDiagramElement.getEStructuralFeatures().add((Object)nodeContainment);
            EClass classLink = EcoreFactory.eINSTANCE.createEClass();
            classLink.setName("Link");
            this.myPackage.getEClassifiers().add((Object)classLink);
            EReference linkContainment = EcoreFactory.eINSTANCE.createEReference();
            linkContainment.setName("linkContainment");
            linkContainment.setEType((EClassifier)classLink);
            linkContainment.setUpperBound(-1);
            linkContainment.setContainment(true);
            node.getEStructuralFeatures().add((Object)linkContainment);
            EReference linkTarget = EcoreFactory.eINSTANCE.createEReference();
            linkTarget.setName("target");
            linkTarget.setEType((EClassifier)node);
            linkTarget.setUpperBound(1);
            classLink.getEStructuralFeatures().add((Object)linkTarget);
            this.myRefLink = EcoreFactory.eINSTANCE.createEReference();
            this.myRefLink.setName("refLink");
            this.myRefLink.setEType((EClassifier)node);
            this.myRefLink.setUpperBound(-1);
            node.getEStructuralFeatures().add((Object)this.myRefLink);
            new ResourceImpl(URI.createURI((String)"uri://org.eclipse.gmf.eh/tests/DomainModelSetup")).getContents().add((Object)this.myPackage);
            this.myNode1 = new DomainModelSource.NodeData(node, node1Name, nodeContainment);
            this.myNode2 = new DomainModelSource.NodeData(node, node2Name, nodeContainment);
            this.myClassLink = new DomainModelSource.LinkData(classLink, (EStructuralFeature)linkTarget, linkContainment);
        }

        public EClass getDiagramElement() {
            return this.myDiagramElement;
        }

        public DomainModelSource.LinkData getLinkAsClass() {
            return this.myClassLink;
        }

        public EReference getLinkAsRef() {
            return this.myRefLink;
        }

        public EPackage getModel() {
            return this.myPackage;
        }

        public DomainModelSource.NodeData getNodeA() {
            return this.myNode1;
        }

        public DomainModelSource.NodeData getNodeB() {
            return this.myNode2;
        }
    }

    private static final class EditHelpersProjectSetup
    extends GenProjectSetup {
        private String myBundleName;
        private BundleResourceManager myResourceManager;

        private EditHelpersProjectSetup(GeneratorConfiguration generatorFactory) {
            super(generatorFactory);
            URL templatesURL = Plugin.getBundleContext().getBundle().getEntry("templates/edithelpers");
            this.myResourceManager = new BundleResourceManager(new URL[]{templatesURL});
        }

        protected void generateDiagramPrerequisites(GenDiagram d) throws Exception {
            super.generateDiagramPrerequisites(d);
            this.generateEditHelpersProject(d);
        }

        private void generateEditHelpersProject(GenDiagram d) {
            this.myBundleName = String.valueOf(Utils.createUniquePluginID()) + ".edithelpers";
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.myBundleName);
            Path srcPath = new Path(String.valueOf('/') + project.getName() + "/src");
            int style = Generator.EMF_PLUGIN_PROJECT_STYLE;
            List pluginVariables = null;
            Generator.createEMFProject((IPath)srcPath, null, Collections.emptyList(), (IProgressMonitor)new NullProgressMonitor(), (int)style, pluginVariables);
            this.createManifestMF();
            for (GenTopLevelNode node : d.getTopLevelNodes()) {
                this.createEditHelper(node);
            }
            this.createPluginXML(d);
            this.projectsToInit.add(this.myBundleName);
        }

        public void createManifestMF() {
            XpandTextEmitter emiter = new XpandTextEmitter((ResourceManager)this.myResourceManager, "manifest::_main", null);
            this.doGenerateFile((TextEmitter)emiter, (IPath)new Path("/" + this.myBundleName + "/META-INF/MANIFEST.MF"), this.myBundleName);
        }

        public void createEditHelper(GenTopLevelNode node) {
            String className;
            ElementType elementType = node.getElementType();
            if (elementType == null) {
                return;
            }
            if (elementType instanceof MetamodelType) {
                className = String.valueOf(((MetamodelType)elementType).getEditHelperClassName()) + "ExternalAdvice";
            } else if (elementType instanceof SpecializationType) {
                String adviceClassName = ((SpecializationType)elementType).getEditHelperAdviceClassName();
                if (adviceClassName == null || adviceClassName.trim().length() == 0) {
                    adviceClassName = node.getUniqueIdentifier();
                }
                className = String.valueOf(adviceClassName) + "ExternalAdvice";
            } else {
                return;
            }
            XpandTextEmitter emiter = new XpandTextEmitter((ResourceManager)this.myResourceManager, "edithelper::_main", null);
            this.doGenerateFile((TextEmitter)emiter, (IPath)new Path("/" + this.myBundleName + "/src/" + className + ".java"), elementType);
        }

        public void createPluginXML(GenDiagram d) {
            XpandTextEmitter emiter = new XpandTextEmitter((ResourceManager)this.myResourceManager, "plugin::_main", null);
            this.doGenerateFile((TextEmitter)emiter, (IPath)new Path("/" + this.myBundleName + "/plugin.xml"), d);
        }

        private void doGenerateFile(TextEmitter emitter, IPath filePath, Object ... param) {
            try {
                IPath containerPath = filePath.removeLastSegments(1);
                CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)containerPath, (boolean)false, null, (IProgressMonitor)new NullProgressMonitor());
                String genText = emitter.generate((IProgressMonitor)new NullProgressMonitor(), param);
                IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
                f.create((InputStream)new ByteArrayInputStream(genText.getBytes(f.getCharset())), true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException ex) {
                EditHelpersTest.fail((String)ex.getMessage());
            }
            catch (UnexpectedBehaviourException ex) {
                EditHelpersTest.fail((String)ex.getMessage());
            }
            catch (CoreException ex) {
                EditHelpersTest.fail((String)ex.getMessage());
            }
            catch (UnsupportedEncodingException ex) {
                EditHelpersTest.fail((String)ex.getMessage());
            }
            catch (InterruptedException ex) {
                EditHelpersTest.fail((String)ex.getMessage());
            }
        }
    }

    public static final class EditHelpersSessionSetup
    extends SessionSetup {
        public EditHelpersSessionSetup() {
            super(new RuntimeBasedGeneratorConfiguration());
        }

        protected DomainModelSource createDomainModel() {
            return new EditHelpersModelSource();
        }

        protected GenProjectSetup createGenProject(GeneratorConfiguration generatorConfiguration) throws BundleException {
            return new EditHelpersProjectSetup(generatorConfiguration).init(this.getGenModel());
        }

        public MapDefSource createMapModel() {
            return new EditHelpersMapSetup().init(this.getGraphDefModel(), this.getDomainModel(), this.getToolDefModel());
        }
    }
}

