/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests;

import java.util.Calendar;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.bridge.genmodel.BasicGenModelAccess;
import org.eclipse.swt.widgets.Display;

public class Utils {
    public static GenModel createGenModel(EPackage aModel) {
        BasicGenModelAccess gmAccess = new BasicGenModelAccess(aModel);
        IStatus s = gmAccess.createDummy();
        assert (s.isOK());
        GenModel genModel = gmAccess.model();
        String pluginID = Utils.createUniquePluginID();
        genModel.setModelPluginID(pluginID);
        genModel.setModelDirectory("/" + pluginID + "/src/");
        genModel.setEditDirectory(genModel.getModelDirectory());
        return genModel;
    }

    public static GenClass findGenClass(GenModel genModel, String className) {
        TreeIterator it = genModel.eAllContents();
        while (it.hasNext()) {
            GenClass rc;
            EObject next = (EObject)it.next();
            if (!(next instanceof GenClassifier)) continue;
            if (next instanceof GenClass && (rc = (GenClass)next).getName().equals(className)) {
                return rc;
            }
            it.prune();
        }
        return null;
    }

    public static GenClass findGenClass(GenModel genModel, EClass domainClass) {
        return Utils.findGenClass(genModel, domainClass.getName());
    }

    public static String createUniquePluginID() {
        Calendar c = Calendar.getInstance();
        return "sample.d" + c.get(6) + ".h" + c.get(11) + ".m" + c.get(12) + ".s" + c.get(13);
    }

    public static boolean dispatchDisplayMessages(boolean[] condition, int timeoutSeconds) {
        assert (Display.getCurrent() != null);
        long start = System.currentTimeMillis();
        long deltaMillis = timeoutSeconds * 1000;
        while (Display.getCurrent().readAndDispatch() || condition[0] && System.currentTimeMillis() - start < deltaMillis) {
        }
        return !condition[0];
    }

    public static boolean dispatchDisplayMessages(int timeoutSeconds) {
        long start = System.currentTimeMillis();
        long deltaMillis = timeoutSeconds * 1000;
        while (Display.getCurrent().readAndDispatch()) {
            if (System.currentTimeMillis() - start <= deltaMillis) continue;
            return false;
        }
        return true;
    }
}

