/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.mappings.AuditContainer;
import org.eclipse.gmf.mappings.AuditRule;
import org.eclipse.gmf.mappings.Auditable;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.Constraint;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LinkConstraints;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.Severity;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.DomainModelSetup;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.MapDefSource;
import org.eclipse.gmf.tests.setup.ToolDefSource;

public class MapSetup
implements MapDefSource {
    private Mapping myMap;
    private NodeMapping myNodeA;
    private NodeMapping myNodeAChild;
    private CompartmentMapping myNodeACompartment;
    private NodeMapping myNodeB;
    private NodeMapping myNodeBChild;
    private CompartmentMapping myNodeBCompartment;
    private LinkMapping myClassLink;
    private LinkMapping myRefLink;
    private LinkMapping myClassLink_Cardinality2;
    private LinkMapping myClassLink_Cardinality1;
    private LinkMapping myRefLink_Cardinality2;
    private LinkMapping myRefLink_Cardinality1;
    private LinkMapping mySelfClassLink;
    private LinkMapping mySelfRefLink;
    private LinkMapping myClassLink2Link;
    private LinkMapping myClassLinkFromLink;
    private LinkMapping myClassLinkCrossLink;
    private LinkMapping myRefLink2Link;
    private LinkMapping myRefLinkFromLink;
    private LinkMapping myRefLinkCrossLink;

    public MapSetup init(DiaDefSource ddSource, DomainModelSource domainSource, ToolDefSource toolDef) {
        this.initCanvasMapping(domainSource.getModel(), ddSource.getCanvasDef(), domainSource.getDiagramElement());
        if (toolDef.getMainMenu() != null) {
            this.myMap.getDiagram().getMenuContributions().add((Object)toolDef.getMainMenu());
        }
        this.myMap.getDiagram().setPalette(toolDef.getPalette());
        this.initCommonMapping(ddSource, domainSource, toolDef);
        if (domainSource instanceof DomainModelSetup && ddSource instanceof DiaDefSetup) {
            this.initSpecificMapping((DiaDefSetup)ddSource, (DomainModelSetup)domainSource, toolDef);
        }
        return this;
    }

    private void initSpecificMapping(DiaDefSetup ddSetup, DomainModelSetup dmSetup, ToolDefSource toolDef) {
        this.myClassLink_Cardinality2 = this.createLinkMapping(ddSetup.getLinkDef(), dmSetup.getLinkAsClass_Cardinality2());
        this.myClassLink_Cardinality2.setTool(toolDef.getLinkCreationTool());
        this.myClassLink_Cardinality1 = this.createLinkMapping(ddSetup.getLinkDef(), dmSetup.getLinkAsClass_Cardinality1());
        this.myClassLink_Cardinality1.setTool(toolDef.getLinkCreationTool());
        this.mySelfClassLink = this.createLinkMapping(ddSetup.getLinkDef(), dmSetup.getSelfLinkAsClass());
        this.mySelfClassLink.setTool(toolDef.getLinkCreationTool());
        this.myRefLink_Cardinality2 = this.createLinkMapping(ddSetup.getLinkDef(), null, (EStructuralFeature)dmSetup.getLinkAsRef_Cardinality2(), null);
        this.myRefLink_Cardinality1 = this.createLinkMapping(ddSetup.getLinkDef(), null, (EStructuralFeature)dmSetup.getLinkAsRef_Cardinality1(), null);
        this.mySelfRefLink = this.createLinkMapping(ddSetup.getLinkDef(), null, (EStructuralFeature)dmSetup.getSelfLinkAsRef(), null);
        this.myClassLink2Link = this.createLinkMapping(ddSetup.getLinkDef(), dmSetup.getLink2Link());
        this.myClassLink2Link.setTool(toolDef.getLinkCreationTool());
        this.myClassLinkFromLink = this.createLinkMapping(ddSetup.getLinkDef(), dmSetup.getLinkFromLink());
        this.myClassLinkFromLink.setTool(toolDef.getLinkCreationTool());
        this.myClassLinkCrossLink = this.createLinkMapping(ddSetup.getLinkDef(), dmSetup.getLinkCrossLink());
        this.myClassLinkCrossLink.setTool(toolDef.getLinkCreationTool());
        this.myRefLink2Link = this.createLinkMapping(ddSetup.getLinkDef(), null, (EStructuralFeature)dmSetup.getLink2LinkRef(), null);
        this.myRefLinkFromLink = this.createLinkMapping(ddSetup.getLinkDef(), null, (EStructuralFeature)dmSetup.getLinkFromLinkRef(), null);
        this.myRefLinkCrossLink = this.createLinkMapping(ddSetup.getLinkDef(), null, (EStructuralFeature)dmSetup.getLinkCrossLinkRef(), null);
        ChildReference childReference = this.createChildNode(ddSetup.getNodeDef(), ddSetup.getLabelDef(), dmSetup.getChildOfA(), this.myNodeA);
        this.myNodeAChild = childReference.getOwnedChild();
        this.myNodeAChild.setTool(toolDef.getNodeCreationTool());
        ChildReference labelOnlyChildReference = this.createChildNode((Node)ddSetup.getLabelDef(), ddSetup.getLabelDef(), dmSetup.getSecondChildOfA(), this.myNodeA);
        this.myNodeACompartment = this.createCompartment(ddSetup.getCompartmentA(), this.myNodeA, new ChildReference[]{childReference, labelOnlyChildReference});
        if (this.myNodeB != null) {
            childReference = this.createChildNode(ddSetup.getColoredNodeDef(), ddSetup.getDecoratedLabelDef(), dmSetup.getChildOfB(), this.myNodeB);
            this.myNodeBChild = childReference.getOwnedChild();
            this.myNodeBCompartment = this.createCompartment(ddSetup.getCompartmentB(), this.myNodeB, new ChildReference[]{childReference});
            ChildReference recursiveChildReference = GMFMapFactory.eINSTANCE.createChildReference();
            recursiveChildReference.setReferencedChild(this.myNodeBChild);
            recursiveChildReference.setChildrenFeature(dmSetup.getChildOfChildOfB().getContainment());
            recursiveChildReference.setContainmentFeature(dmSetup.getChildOfChildOfB().getContainment());
            this.myNodeBChild.getChildren().add((Object)recursiveChildReference);
            this.createCompartment(ddSetup.getCompartmentB(), this.myNodeBChild, new ChildReference[]{recursiveChildReference});
        }
        NodeMapping nodeC = this.createNodeMapping(ddSetup.getNodeDef(), ddSetup.getLabelDef(), dmSetup.getNodeD());
        this.createChildNode(ddSetup.getNodeDef(), ddSetup.getLabelDef(), dmSetup.getChildOfB(), nodeC);
    }

    private void initCommonMapping(DiaDefSource ddSource, DomainModelSource domainSource, ToolDefSource toolDef) {
        DiaDefSetup ddSetup;
        this.myNodeA = this.createNodeMapping(ddSource.getNodeDef(), ddSource.getLabelDef(), domainSource.getNodeA());
        this.myNodeA.setContextMenu(toolDef.getNodeContextMenu());
        this.myNodeA.setTool(toolDef.getNodeCreationTool());
        DiaDefSetup diaDefSetup = ddSetup = ddSource instanceof DiaDefSetup ? (DiaDefSetup)ddSource : null;
        if (domainSource.getNodeB() != null) {
            Node graphNode = ddSetup != null ? ddSetup.getColoredNodeDef() : ddSource.getNodeDef();
            DiagramLabel graphLabel = ddSetup != null ? ddSetup.getDecoratedLabelDef() : ddSource.getLabelDef();
            this.myNodeB = this.createNodeMapping(graphNode, graphLabel, domainSource.getNodeB());
        }
        this.myClassLink = this.createLinkMapping(ddSource.getLinkDef(), domainSource.getLinkAsClass());
        this.myClassLink.setTool(toolDef.getLinkCreationTool());
        if (domainSource.getLinkAsRef() != null) {
            this.myRefLink = this.createLinkMapping(ddSetup != null ? ddSetup.getColoredLinkDef() : ddSource.getLinkDef(), null, (EStructuralFeature)domainSource.getLinkAsRef(), null);
        }
    }

    private CompartmentMapping createCompartment(Compartment diagramCompartment, NodeMapping parent, ChildReference[] childReferences) {
        CompartmentMapping compartmentMapping = GMFMapFactory.eINSTANCE.createCompartmentMapping();
        compartmentMapping.setCompartment(diagramCompartment);
        compartmentMapping.getChildren().addAll((Collection)Arrays.asList(childReferences));
        parent.getCompartments().add((Object)compartmentMapping);
        return compartmentMapping;
    }

    private ChildReference createChildNode(Node diagramNode, DiagramLabel diagramLabel, DomainModelSource.NodeData domainNode, NodeMapping parent) {
        NodeMapping nodeMapping = this.createNodeMapping(diagramNode, domainNode.getEClass(), diagramLabel, domainNode.getNameAttr(), domainNode.getContainment(), false);
        ChildReference childReference = GMFMapFactory.eINSTANCE.createChildReference();
        childReference.setOwnedChild(nodeMapping);
        childReference.setChildrenFeature(domainNode.getContainment());
        childReference.setContainmentFeature(domainNode.getContainment());
        parent.getChildren().add((Object)childReference);
        return childReference;
    }

    private void initCanvasMapping(EPackage domainModel, Canvas canvas, EClass diagramElement) {
        Mapping m = GMFMapFactory.eINSTANCE.createMapping();
        CanvasMapping cme = GMFMapFactory.eINSTANCE.createCanvasMapping();
        cme.setDiagramCanvas(canvas);
        cme.setDomainMetaElement(diagramElement);
        cme.setDomainModel(domainModel);
        this.setupCanvasMapping(cme);
        m.setDiagram(cme);
        this.myMap = m;
    }

    protected final AuditRule createAudit(String id, String ruleBody, Auditable target, Severity severity, boolean isLiveMode) {
        AuditRule audit = GMFMapFactory.eINSTANCE.createAuditRule();
        audit.setId(id);
        audit.setName("Name of \"" + id + "\"");
        audit.setMessage("Violation of \"" + id + "\"");
        audit.setDescription("Description of \"" + id + "\"");
        audit.setTarget(target);
        Constraint rule = GMFMapFactory.eINSTANCE.createConstraint();
        rule.setBody(ruleBody);
        audit.setRule(rule);
        audit.setSeverity(severity);
        audit.setUseInLiveMode(isLiveMode);
        return audit;
    }

    protected final AuditContainer createAuditContainer(String id) {
        AuditContainer container = GMFMapFactory.eINSTANCE.createAuditContainer();
        container.setId(id);
        container.setName("Name of \"" + id + "\"");
        container.setDescription("Description of \"" + id + "\"");
        return container;
    }

    private LinkMapping createLinkMapping(Connection link, DomainModelSource.LinkData data) {
        return this.createLinkMapping(link, data.getEClass(), data.getTargetFeature(), data.getContainment());
    }

    private LinkMapping createLinkMapping(Connection link, EClass domainMetaElement, EStructuralFeature linkMetafeature, EReference containmentFeature) {
        LinkMapping lme = GMFMapFactory.eINSTANCE.createLinkMapping();
        lme.setDiagramLink(link);
        lme.setDomainMetaElement(domainMetaElement);
        lme.setLinkMetaFeature(linkMetafeature);
        lme.setContainmentFeature(containmentFeature);
        if (domainMetaElement == null) {
            this.setupReferenceLinkMapping(lme);
        } else {
            this.setupClassLinkMapping(lme);
        }
        this.myMap.getLinks().add((Object)lme);
        return lme;
    }

    private NodeMapping createNodeMapping(Node nodeDef, DiagramLabel labelDef, DomainModelSource.NodeData nodeData) {
        return this.createNodeMapping(nodeDef, nodeData.getEClass(), labelDef, nodeData.getNameAttr(), nodeData.getContainment());
    }

    private NodeMapping createNodeMapping(Node nodeDef, EClass domainMetaElement, DiagramLabel labelDef, EAttribute editFeature, EReference containmentFeature) {
        return this.createNodeMapping(nodeDef, domainMetaElement, labelDef, editFeature, containmentFeature, true);
    }

    protected final NodeMapping createNodeMapping(Node nodeDef, EClass domainMetaElement, DiagramLabel labelDef, EAttribute editFeature, EReference containmentFeature, boolean addTopNodeReference) {
        NodeMapping nme = GMFMapFactory.eINSTANCE.createNodeMapping();
        nme.setDiagramNode(nodeDef);
        nme.setDomainMetaElement(domainMetaElement);
        if (editFeature != null) {
            FeatureLabelMapping lm = GMFMapFactory.eINSTANCE.createFeatureLabelMapping();
            lm.getFeatures().add((Object)editFeature);
            lm.setDiagramLabel(labelDef);
            nme.getLabelMappings().add((Object)lm);
        }
        this.setupNodeMapping(nme);
        if (addTopNodeReference) {
            TopNodeReference tnr = GMFMapFactory.eINSTANCE.createTopNodeReference();
            tnr.setOwnedChild(nme);
            tnr.setContainmentFeature(containmentFeature);
            this.myMap.getNodes().add((Object)tnr);
        }
        return nme;
    }

    protected void addCreationConstraints(LinkMapping linkMapping, String sourceConstraint, String endConstraint) {
        LinkConstraints constraints = GMFMapFactory.eINSTANCE.createLinkConstraints();
        if (sourceConstraint != null) {
            Constraint source = GMFMapFactory.eINSTANCE.createConstraint();
            source.setBody(sourceConstraint);
            constraints.setSourceEnd(source);
        }
        if (endConstraint != null) {
            Constraint target = GMFMapFactory.eINSTANCE.createConstraint();
            target.setBody(endConstraint);
            constraints.setTargetEnd(target);
        }
        linkMapping.setCreationConstraints(constraints);
    }

    protected void setupCanvasMapping(CanvasMapping cme) {
    }

    protected void setupNodeMapping(NodeMapping nme) {
    }

    protected void setupClassLinkMapping(LinkMapping lme) {
    }

    protected void setupReferenceLinkMapping(LinkMapping lme) {
    }

    public final Mapping getMapping() {
        return this.myMap;
    }

    public NodeMapping getNodeA() {
        return this.myNodeA;
    }

    public NodeMapping getNodeB() {
        return this.myNodeB;
    }

    public LinkMapping getClassLink() {
        return this.myClassLink;
    }

    public LinkMapping getClassLink_Cardinality2() {
        return this.myClassLink_Cardinality2;
    }

    public LinkMapping getClassLink_Cardinality1() {
        return this.myClassLink_Cardinality1;
    }

    public LinkMapping getSelfClassLink() {
        return this.mySelfClassLink;
    }

    public LinkMapping getReferenceLink() {
        return this.myRefLink;
    }

    public LinkMapping getReferenceLink_Cardinality2() {
        return this.myRefLink_Cardinality2;
    }

    public LinkMapping getReferenceLink_Cardinality1() {
        return this.myRefLink_Cardinality1;
    }

    public LinkMapping getSelfReferenceLink() {
        return this.mySelfRefLink;
    }

    public NodeMapping getNodeAChild() {
        return this.myNodeAChild;
    }

    public CompartmentMapping getNodeACompartment() {
        return this.myNodeACompartment;
    }

    public NodeMapping getNodeBChild() {
        return this.myNodeBChild;
    }

    public CompartmentMapping getNodeBCompartment() {
        return this.myNodeBCompartment;
    }

    public LinkMapping getClassLink2Link() {
        return this.myClassLink2Link;
    }

    public LinkMapping getClassLinkFromLink() {
        return this.myClassLinkFromLink;
    }

    public LinkMapping getClassLinkCrossLink() {
        return this.myClassLinkCrossLink;
    }

    public LinkMapping getReferenceLink2Link() {
        return this.myRefLink2Link;
    }

    public LinkMapping getReferenceLinkFromLink() {
        return this.myRefLinkFromLink;
    }

    public LinkMapping getReferenceLinkCrossLink() {
        return this.myRefLinkCrossLink;
    }
}

