/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.LogicDiagramPlugin;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.Assert;

public class DiagramCreator {
    public static Diagram createEmptyDiagram(final PreferencesHint preferencesHint, TransactionalEditingDomain editingDomain) {
        final Diagram[] dgmContainer = new Diagram[1];
        AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, ""){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Diagram diagram = ViewService.createDiagram((String)"logic", (PreferencesHint)preferencesHint);
                Assert.isNotNull((Object)diagram);
                dgmContainer[0] = diagram;
                return Status.OK_STATUS;
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return dgmContainer[0];
    }

    public static List createNodes(final Diagram diagram, final PreferencesHint preferencesHint, TransactionalEditingDomain editingDomain) {
        final ArrayList list = new ArrayList(2);
        AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, ""){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Node note1 = ViewService.createNode((View)diagram, (String)ViewType.NOTE, (PreferencesHint)preferencesHint);
                Assert.isNotNull((Object)note1, (String)"Note1 creation failed");
                Assert.isTrue((diagram.getChildren().get(0) == note1 ? 1 : 0) != 0, (String)"Note1 is not inserted in diagram");
                Node note2 = ViewService.createNode((View)diagram, (String)ViewType.NOTE, (PreferencesHint)preferencesHint);
                Assert.isNotNull((Object)note2, (String)"Note2 creation failed");
                Assert.isTrue((diagram.getChildren().get(1) == note2 ? 1 : 0) != 0, (String)"Note2 is not inserted in diagram");
                Edge noteAttachment = ViewService.createEdge((View)note1, (View)note2, (String)ViewType.NOTEATTACHMENT, (PreferencesHint)preferencesHint);
                Assert.isNotNull((Object)noteAttachment, (String)"NoteAttachment creation failed");
                Assert.isTrue((diagram.getEdges().get(0) == noteAttachment ? 1 : 0) != 0, (String)"NoteAttachment is not inserted in diagram");
                Assert.isTrue((note1.getSourceEdges().get(0) == noteAttachment ? 1 : 0) != 0, (String)"NoteAttachment is not inserted in note1");
                Assert.isTrue((note2.getTargetEdges().get(0) == noteAttachment ? 1 : 0) != 0, (String)"NoteAttachment is not inserted in note2");
                Assert.isTrue((noteAttachment.getSource() == note1 ? 1 : 0) != 0, (String)"Note1 is not source for noteattachment");
                Assert.isTrue((noteAttachment.getTarget() == note2 ? 1 : 0) != 0, (String)"Note2 is not target for noteattachment");
                list.add(note1);
                list.add(note2);
                return new Status(0, LogicDiagramPlugin.getPluginId(), 0, "", null);
            }
        };
        try {
            operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return list;
    }
}

