/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.parts;

import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.gmf.internal.runtime.lite.Activator;
import org.eclipse.gmf.runtime.lite.parts.DiagramDisplayer;
import org.eclipse.gmf.runtime.lite.parts.IDiagramManager;
import org.eclipse.gmf.runtime.lite.services.DefaultDiagramLayouter;
import org.eclipse.gmf.runtime.lite.services.IDiagramLayouter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiagramViewPart
extends ViewPart
implements IDiagramManager {
    private DiagramDisplayer myDiagramDisplayer;
    private PageBook myBook;
    private Control myUninitializedControl;
    private CommandStackEventListener mySaveListener = new CommandStackEventListener(){

        public void stackChanged(CommandStackEvent event) {
            if (!$assertionsDisabled && event.getSource() != DiagramViewPart.this.myDiagramDisplayer.getCommandStack()) {
                throw new AssertionError();
            }
            if (event.isPostChangeEvent()) {
                try {
                    DiagramViewPart.this.myDiagramDisplayer.save(DiagramViewPart.this.getSaveOptions(), (IProgressMonitor)new NullProgressMonitor());
                    DiagramViewPart.this.myDiagramDisplayer.getCommandStack().markSaveLocation();
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    protected Map<?, ?> getSaveOptions() {
        return Collections.emptyMap();
    }

    public void dispose() {
        if (this.myDiagramDisplayer != null) {
            this.disposeDisplayer(this.myDiagramDisplayer);
        }
        this.myDiagramDisplayer = null;
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.myBook = new PageBook(parent, 0);
        this.myUninitializedControl = this.createUninitializedControl((Composite)this.myBook);
        this.myBook.showPage(this.myUninitializedControl);
    }

    public void setFocus() {
        if (this.myDiagramDisplayer != null) {
            this.myDiagramDisplayer.setFocus();
            return;
        }
        this.myBook.setFocus();
    }

    protected TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        editingDomain.getResourceSet().eAdapters().add((Object)new AdapterFactoryEditingDomain.EditingDomainProvider((EditingDomain)editingDomain));
        return editingDomain;
    }

    protected abstract void createActions();

    public final boolean showDiagram(TransactionalEditingDomain editingDomain, URI diagramURI) {
        boolean result;
        DiagramDisplayer oldDiagramDisplayer;
        block7: {
            oldDiagramDisplayer = this.myDiagramDisplayer;
            result = false;
            if (diagramURI == null) {
                if (oldDiagramDisplayer == null) {
                    return true;
                }
                this.myBook.showPage(this.myUninitializedControl);
            } else {
                if (editingDomain == null) {
                    editingDomain = this.createEditingDomain();
                }
                this.myDiagramDisplayer = new DiagramDisplayer(this, this.createEditDomain(), editingDomain);
                this.initDisplayer(this.myDiagramDisplayer);
                try {
                    this.setInput(diagramURI);
                    this.myDiagramDisplayer.createViewer((Composite)this.myBook);
                    this.createActions();
                    this.myBook.showPage(this.myDiagramDisplayer.getTopLevelControl());
                    result = true;
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error", (String)"Failed to open diagram", (IStatus)e.getStatus());
                    if (this.myDiagramDisplayer.getTopLevelControl() == null || this.myDiagramDisplayer.getTopLevelControl().isDisposed()) break block7;
                    this.disposeDisplayer(this.myDiagramDisplayer);
                    this.myDiagramDisplayer = oldDiagramDisplayer;
                    oldDiagramDisplayer = null;
                }
            }
        }
        if (oldDiagramDisplayer != null) {
            this.disposeDisplayer(oldDiagramDisplayer);
        }
        this.updateActionBars();
        return result;
    }

    protected void initDisplayer(DiagramDisplayer diagramDisplayer) {
        diagramDisplayer.getCommandStack().addCommandStackEventListener(this.mySaveListener);
    }

    protected void disposeDisplayer(DiagramDisplayer diagramDisplayer) {
        if (diagramDisplayer.getTopLevelControl() != null) {
            diagramDisplayer.getTopLevelControl().dispose();
        }
        diagramDisplayer.getCommandStack().removeCommandStackEventListener(this.mySaveListener);
        diagramDisplayer.dispose();
    }

    protected abstract void updateActionBars();

    @Override
    public void configureGraphicalViewer() {
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
    }

    protected double[] getZoomLevels() {
        double[] result = new double[]{0.05, 0.1, 0.25, 0.5, 0.75, 1.0, 1.25, 1.5, 1.75, 2.0, 4.0};
        return result;
    }

    @Override
    public abstract void configurePalette(PaletteRoot var1);

    protected abstract void setInput(URI var1) throws CoreException;

    protected EditDomain createEditDomain() {
        EditDomain domain = new EditDomain();
        return domain;
    }

    public final TransactionalEditingDomain getEditingDomain() {
        if (this.myDiagramDisplayer == null) {
            return null;
        }
        return this.myDiagramDisplayer.getEditingDomain();
    }

    protected final EditDomain getEditDomain() {
        if (this.myDiagramDisplayer == null) {
            return null;
        }
        return this.myDiagramDisplayer.getEditDomain();
    }

    protected final CommandStack getCommandStack() {
        if (this.myDiagramDisplayer == null) {
            return null;
        }
        return this.getEditDomain().getCommandStack();
    }

    protected final ZoomManager getZoomManager() {
        if (this.myDiagramDisplayer == null) {
            return null;
        }
        return this.myDiagramDisplayer.getZoomManager();
    }

    protected final ActionRegistry getActionRegistry() {
        if (this.myDiagramDisplayer == null) {
            return null;
        }
        return this.myDiagramDisplayer.getActionRegistry();
    }

    protected final GraphicalViewer getGraphicalViewer() {
        if (this.myDiagramDisplayer == null) {
            return null;
        }
        return this.myDiagramDisplayer.getGraphicalViewer();
    }

    protected IPropertySheetPage getPropertySheetPage() {
        if (this.myDiagramDisplayer == null) {
            return null;
        }
        return this.myDiagramDisplayer.getPropertySheetPage();
    }

    protected IDiagramLayouter getDiagramLayouter() {
        if (this.myDiagramDisplayer == null) {
            return null;
        }
        return new DefaultDiagramLayouter();
    }

    public Object getAdapter(Class type) {
        if (type == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (type == IContentOutlinePage.class) {
            return null;
        }
        if (type == ZoomManager.class) {
            return this.getZoomManager();
        }
        if (type == IDiagramLayouter.class) {
            return this.getDiagramLayouter();
        }
        if (type == PalettePage.class) {
            return this.myDiagramDisplayer.getPalettePage();
        }
        if (type == GraphicalViewer.class) {
            return this.getGraphicalViewer();
        }
        if (type == CommandStack.class) {
            return this.getCommandStack();
        }
        if (type == ActionRegistry.class) {
            return this.getActionRegistry();
        }
        if (type == EditPart.class && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        if (type == IFigure.class && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure();
        }
        return super.getAdapter(type);
    }

    protected void addAction(IAction action) {
        this.myDiagramDisplayer.addAction(action);
    }

    protected void addEditorAction(WorkbenchPartAction action) {
        this.myDiagramDisplayer.addEditorAction(action);
    }

    protected void addEditPartAction(SelectionAction action) {
        this.myDiagramDisplayer.addEditPartAction(action);
    }

    protected void addStackAction(StackAction action) {
        this.myDiagramDisplayer.addStackAction(action);
    }

    protected Control createUninitializedControl(Composite parent) {
        Label result = new Label(parent, 0);
        result.setText("There is no diagram to display or the diagram failed to load");
        return result;
    }

    @Override
    public abstract AdapterFactory getDomainAdapterFactory();

    @Override
    public abstract void initializeGraphicalViewer();

    @Override
    public abstract boolean isFlyoutPalette();
}

