/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.ListIterator;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.actions.PropertyChangeAction;
import org.eclipse.gmf.runtime.diagram.ui.internal.properties.Properties;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.TextAlignment;
import org.eclipse.gmf.runtime.notation.TextStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IWorkbenchPage;

public class TextAlignmentAction
extends PropertyChangeAction {
    private TextAlignment textAlignment;

    protected TextAlignmentAction(IWorkbenchPage workbenchPage, TextAlignment textAlignment) {
        super(workbenchPage, Properties.ID_TEXT_ALIGNMENT, DiagramUIActionsMessages.TextAlignmentAction_ChangePropertyValueRequest_label);
        this.textAlignment = textAlignment;
    }

    public static TextAlignmentAction createTextAlignmentLeftAction(IWorkbenchPage workbenchPage) {
        TextAlignmentAction action = new TextAlignmentAction(workbenchPage, TextAlignment.LEFT_LITERAL);
        action.setId("textAlignmentLeftAction");
        action.setText(DiagramUIActionsMessages.TextAlignmentAction_left);
        action.setToolTipText(DiagramUIActionsMessages.TextAlignmentAction_ChangePropertyValueRequest_label);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_TEXT_ALIGNMENT_LEFT);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_TEXT_ALIGNMENT_LEFT_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_TEXT_ALIGNMENT_LEFT);
        return action;
    }

    public static TextAlignmentAction createTextAlignmentCenterAction(IWorkbenchPage workbenchPage) {
        TextAlignmentAction action = new TextAlignmentAction(workbenchPage, TextAlignment.CENTER_LITERAL);
        action.setId("textAlignmentCenterAction");
        action.setText(DiagramUIActionsMessages.TextAlignmentAction_center);
        action.setToolTipText(DiagramUIActionsMessages.TextAlignmentAction_ChangePropertyValueRequest_label);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_TEXT_ALIGNMENT_CENTER);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_TEXT_ALIGNMENT_CENTER_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_TEXT_ALIGNMENT_CENTER);
        return action;
    }

    public static TextAlignmentAction createTextAlignmentRightAction(IWorkbenchPage workbenchPage) {
        TextAlignmentAction action = new TextAlignmentAction(workbenchPage, TextAlignment.RIGHT_LITERAL);
        action.setId("textAlignmentRightAction");
        action.setText(DiagramUIActionsMessages.TextAlignmentAction_right);
        action.setToolTipText(DiagramUIActionsMessages.TextAlignmentAction_ChangePropertyValueRequest_label);
        action.setImageDescriptor(DiagramUIActionsPluginImages.DESC_TEXT_ALIGNMENT_RIGHT);
        action.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_TEXT_ALIGNMENT_RIGHT_DISABLED);
        action.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_TEXT_ALIGNMENT_RIGHT);
        return action;
    }

    protected boolean calculateEnabled() {
        if (this.getId() == "textAlignmentLeftAction" || this.getId() == "textAlignmentCenterAction" || this.getId() == "textAlignmentRightAction") {
            ListIterator li = this.getSelectedObjects().listIterator();
            while (li.hasNext()) {
                View view;
                TextStyle style;
                Object object = li.next();
                if (!(object instanceof IGraphicalEditPart)) {
                    return false;
                }
                IGraphicalEditPart node = (IGraphicalEditPart)object;
                if (node.getModel() == null || (style = (TextStyle)(view = (View)node.getModel()).getStyle(NotationPackage.Literals.TEXT_STYLE)) != null) continue;
                return false;
            }
        }
        return super.calculateEnabled();
    }

    protected Object getNewPropertyValue() {
        return this.textAlignment;
    }
}

