/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.internal.bridge.ui.FileSelector;
import org.eclipse.gmf.internal.bridge.wizards.pages.FileDomainModelSource;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DomainModelSelectionPage
extends WizardPage {
    protected FileDomainModelSource domainModelSource;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.wizards.pages.DomainModelSelectionPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DomainModelSelectionPage(String pageId, IStructuredSelection selection, FileDomainModelSource domainModelSource) {
        super(pageId);
        Object selected;
        if (!$assertionsDisabled && domainModelSource == null) {
            throw new AssertionError();
        }
        this.domainModelSource = domainModelSource;
        if (selection != null && !selection.isEmpty() && (selected = selection.getFirstElement()) instanceof IFile) {
            domainModelSource.setFile((IFile)selected);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label label = new Label(composite, 0);
        label.setText("File name");
        data = new GridData();
        label.setLayoutData((Object)data);
        final Text text = new Text(composite, 2052);
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data2);
        if (this.domainModelSource.getFile() != null) {
            text.setText(this.domainModelSource.getFile().getFullPath().toString());
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent me) {
                DomainModelSelectionPage.this.domainModelSource.setFile(null);
                try {
                    Path filePath = new Path(text.getText());
                    if (!filePath.isEmpty()) {
                        DomainModelSelectionPage.this.domainModelSource.setFile(DomainModelSelectionPage.this.createFileHandle((IPath)filePath));
                    }
                }
                catch (Exception exception) {}
                DomainModelSelectionPage.this.setPageComplete(DomainModelSelectionPage.this.validatePage());
            }
        });
        Button button = new Button(composite, 8);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DomainModelSelectionPage.this.domainModelSource.setFile(FileSelector.selectFile(DomainModelSelectionPage.this.getShell(), "Domain Model File", null, DomainModelSelectionPage.this.domainModelSource.getFile(), "ecore"));
                if (DomainModelSelectionPage.this.domainModelSource.getFile() != null) {
                    text.setText(DomainModelSelectionPage.this.domainModelSource.getFile().getFullPath().toString());
                } else {
                    text.setText("");
                }
                DomainModelSelectionPage.this.setPageComplete(DomainModelSelectionPage.this.validatePage());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        button.setText("Browse");
        GridData data3 = new GridData();
        button.setLayoutData((Object)data3);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    protected IFile createFileHandle(IPath filePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    protected boolean validatePage() {
        return this.domainModelSource.getFile() != null;
    }
}

