/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.clipboard.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardUtil;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.osgi.framework.Bundle;

public abstract class BaseClipboardTest
extends TestCase {
    static final Bundle CLIPBOARD_TESTS_BUNDLE;
    protected static final String PROJECT_NAME = "clipboardTests";
    protected static final String RESOURCE_NAME = "/clipboardTests/logres.extlibrary";
    private Transaction tx;
    private ChangeDescription lastChange;
    protected TransactionalEditingDomain domain;
    protected IProject project;
    protected Resource testResource;
    protected Library root1;
    protected Writer level1writer;
    protected Book level1book;
    protected Library level1;
    protected Writer level12writer;
    protected Book level12book;
    protected Library level12;
    protected Library root2;
    protected Writer level2writer;
    protected Book level2book;
    protected Library root3;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.runtime.emf.clipboard.core.BaseClipboardTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        CLIPBOARD_TESTS_BUNDLE = Platform.getBundle((String)"org.eclipse.gmf.tests.runtime.emf.clipboard.core");
    }

    public BaseClipboardTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (!this.project.exists()) {
            this.project.create(null);
        }
        this.project.open(null);
        this.domain = GMFEditingDomainFactory.getInstance().createEditingDomain();
        this.tx = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
        try {
            Resource originalRes = this.domain.getResourceSet().getResource(URI.createURI((String)CLIPBOARD_TESTS_BUNDLE.getEntry("/test_models/clipboard_test.extlibrary").toString()), true);
            originalRes.setURI(URI.createPlatformResourceURI((String)RESOURCE_NAME));
            originalRes.save(Collections.EMPTY_MAP);
            this.testResource = originalRes;
            this.root1 = (Library)this.testResource.getContents().get(0);
            this.level1writer = (Writer)this.root1.getWriters().get(0);
            this.level1book = (Book)this.root1.getBooks().get(0);
            this.level1 = (Library)this.root1.getBranches().get(0);
            this.level12writer = (Writer)this.level1.getWriters().get(0);
            this.level12book = (Book)this.level1.getBooks().get(0);
            this.level12 = (Library)this.level1.getBranches().get(0);
            this.root2 = (Library)this.testResource.getContents().get(1);
            this.level2writer = (Writer)this.root2.getWriters().get(0);
            this.level2book = (Book)this.root2.getBooks().get(0);
            this.root3 = (Library)this.testResource.getContents().get(2);
        }
        catch (IOException e) {
            BaseClipboardTest.fail((String)("Failed to load test model: " + e.getLocalizedMessage()));
        }
    }

    protected void tearDown() throws Exception {
        this.root1 = null;
        this.level1writer = null;
        this.level1book = null;
        this.level1 = null;
        this.level12writer = null;
        this.level12book = null;
        this.level12 = null;
        this.root2 = null;
        this.level2writer = null;
        this.level2book = null;
        this.root3 = null;
        if (this.testResource != null) {
            if (this.testResource.isLoaded()) {
                this.testResource.unload();
            }
            if (this.testResource.getResourceSet() != null) {
                this.testResource.getResourceSet().getResources().remove((Object)this.testResource);
            }
            this.testResource = null;
        }
        if (this.project != null && this.project.exists()) {
            this.project.delete(true, true, null);
        }
        this.project = null;
        this.domain = null;
    }

    protected String copy(Collection objects, Map hints) {
        try {
            return ClipboardUtil.copyElementsToString((Collection)objects, (Map)hints, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            BaseClipboardTest.fail((String)"Failed to copy elements to string.");
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection paste(String str, Object target, Map hints) {
        if (!($assertionsDisabled || target instanceof Resource || target instanceof EObject)) {
            throw new AssertionError();
        }
        Collection result = null;
        InternalTransaction pasteTx = null;
        try {
            pasteTx = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
        }
        catch (Exception e) {
            BaseClipboardTest.fail((String)("Failed to paste elements from string: " + e.getLocalizedMessage()));
        }
        try {
            block12: {
                try {
                    if (target instanceof Resource) {
                        result = ClipboardUtil.pasteElementsFromString((String)str, (Resource)((Resource)target), (Map)hints, (IProgressMonitor)new NullProgressMonitor());
                        break block12;
                    }
                    result = ClipboardUtil.pasteElementsFromString((String)str, (EObject)((EObject)target), (Map)hints, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (Exception exception) {
                    BaseClipboardTest.fail((String)"Failed to paste elements from string.");
                }
            }
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                pasteTx.commit();
                throw throwable;
            }
            catch (RollbackException e) {
                BaseClipboardTest.fail((String)("Failed to paste elements from string: " + e.getLocalizedMessage()));
            }
            throw throwable;
        }
        try {}
        catch (RollbackException e) {
            BaseClipboardTest.fail((String)("Failed to paste elements from string: " + e.getLocalizedMessage()));
            return result;
        }
        pasteTx.commit();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean writing() {
        block13: {
            result = this.tx != null;
            if (result != false) return result;
            try {
                this.tx = ((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null);
            }
            catch (Exception e) {
                BaseClipboardTest.fail((String)("Could not start transaction: " + e.getLocalizedMessage()));
            }
            try {
                try {
                    this.runTest();
                }
                catch (AssertionFailedError e) {
                    this.tx.rollback();
                    throw e;
                }
                catch (Exception e) {
                    this.tx.rollback();
                    e.printStackTrace();
                    BaseClipboardTest.fail((String)("Unexpected exception: " + e.getLocalizedMessage()));
                }
                catch (Throwable t) {
                    this.tx.rollback();
                    throw (Error)t;
                }
            }
            catch (Throwable var4_6) {
                var3_7 = null;
                if (this.tx.isActive() == false) throw var4_6;
                try {
                    this.tx.commit();
                    throw var4_6;
                }
                catch (RollbackException e) {
                    BaseClipboardTest.fail((String)("Transaction rolled back: " + e.getLocalizedMessage()));
                }
                throw var4_6;
            }
            {
                var3_8 = null;
            }
            if (this.tx.isActive()) {
                ** try [egrp 3[TRYBLOCK] [6 : 157->169)] { 
lbl36:
                // 1 sources

                this.tx.commit();
                break block13;
lbl38:
                // 1 sources

                catch (RollbackException e) {
                    BaseClipboardTest.fail((String)("Transaction rolled back: " + e.getLocalizedMessage()));
                }
            }
        }
        this.lastChange = this.tx.getChangeDescription();
        return result;
    }

    protected ChangeDescription getLastChange() {
        return this.lastChange;
    }
}

