/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.SelectionHandlesEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.PageBreakEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.figures.PageBreaksFigure;

public class PageBreakNonResizableEditPolicy
extends SelectionHandlesEditPolicy {
    private Point _paperSize;
    private Rectangle _newBounds;
    private int _rows;
    private int _cols;
    private PageBreaksFigure _feedback;
    private Rectangle _originalLocation;

    protected IFigure createDragSourceFeedbackFigure() {
        IFigure pageBreaksFeedbackFigure = this.createPageBreakFeedbackFigure();
        if (pageBreaksFeedbackFigure != null) {
            this.addFeedback(pageBreaksFeedbackFigure);
        }
        return pageBreaksFeedbackFigure;
    }

    protected IFigure createPageBreakFeedbackFigure() {
        PageBreaksFigure feedBackFigure = new PageBreaksFigure(false);
        PageBreakEditPart pageBreakEditPart = (PageBreakEditPart)this.getHost();
        PageBreaksFigure pageBreakFigure = (PageBreaksFigure)pageBreakEditPart.getFigure();
        this._paperSize = pageBreakEditPart.getPageSize();
        feedBackFigure.setPageCount(pageBreakFigure.getPageCount().x, pageBreakFigure.getPageCount().y);
        feedBackFigure.setBounds(this.getBounds());
        this._rows = pageBreakFigure.getPageCount().x;
        this._cols = pageBreakFigure.getPageCount().y;
        this._paperSize = ((PageBreakEditPart)this.getHost()).getPageSize();
        return feedBackFigure;
    }

    protected List createSelectionHandles() {
        return Collections.EMPTY_LIST;
    }

    public void deactivate() {
        if (this._feedback != null) {
            this.removeFeedback((IFigure)this._feedback);
            this._feedback = null;
        }
        this.hideFocus();
        super.deactivate();
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        if (this._feedback != null) {
            this.removeFeedback((IFigure)this._feedback);
        }
        this._feedback = null;
        this._originalLocation = null;
    }

    public void eraseSourceFeedback(Request request) {
        if ("move".equals(request.getType())) {
            this.eraseChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    private Rectangle getBounds() {
        return ((GraphicalEditPart)this.getHost()).getFigure().getBounds();
    }

    public Command getCommand(Request request) {
        if ("move".equals(request.getType())) {
            this.getHost().activate();
            return this.getMoveCommand((ChangeBoundsRequest)request);
        }
        return null;
    }

    protected IFigure getDragSourceFeedbackFigure() {
        if (this._feedback == null) {
            IFigure fig = ((GraphicalEditPart)this.getHost()).getFigure();
            this._originalLocation = new Rectangle(fig.getBounds());
            this._feedback = (PageBreaksFigure)this.createDragSourceFeedbackFigure();
        }
        return this._feedback;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move children");
        req.setEditParts(this.getHost());
        IFigure pageBreaksFigure = ((GraphicalEditPart)this.getHost()).getFigure();
        Rectangle moveDelta = new Rectangle(0, 0, request.getMoveDelta().x, request.getMoveDelta().y);
        pageBreaksFigure.translateToRelative((Translatable)moveDelta);
        Rectangle sizeDelta = new Rectangle(0, 0, request.getSizeDelta().width, request.getSizeDelta().height);
        pageBreaksFigure.translateToRelative((Translatable)sizeDelta);
        req.setMoveDelta(new Point(moveDelta.width, moveDelta.height));
        req.setSizeDelta(sizeDelta.getSize());
        req.setLocation(request.getLocation());
        return this.getHost().getParent().getCommand((Request)req);
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IFigure p = this.getDragSourceFeedbackFigure();
        Rectangle moveDelta = new Rectangle(0, 0, request.getMoveDelta().x, request.getMoveDelta().y);
        p.translateToRelative((Translatable)moveDelta);
        Rectangle r = this._originalLocation.getTranslated(new Point(moveDelta.width, moveDelta.height));
        r.width += request.getSizeDelta().width;
        r.height += request.getSizeDelta().height;
        ((GraphicalEditPart)this.getHost()).getFigure().translateToAbsolute((Translatable)r);
        p.translateToRelative((Translatable)r);
        ((PageBreaksFigure)p).setPageCount(this._rows, this._cols);
        p.setBounds(r);
    }

    public void showSourceFeedback(Request request) {
        if ("move".equals(request.getType())) {
            this.showChangeBoundsFeedback((ChangeBoundsRequest)request);
        }
    }

    public boolean understandsRequest(Request request) {
        return "move".equals(request.getType());
    }

    protected Rectangle getNewBounds() {
        return this._newBounds;
    }

    protected Point getPaperSize() {
        return this._paperSize;
    }

    protected int getRows() {
        return this._rows;
    }

    protected PageBreaksFigure getFeedback() {
        return this._feedback;
    }

    protected Rectangle getOriginalLocation() {
        return this._originalLocation;
    }
}

