/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.xtend.ast;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.DeclaredParameter;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.migration.ExpressionAnalyzeTrace;
import org.eclipse.gmf.internal.xpand.xtend.ast.Extension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionExtensionStatement
extends Extension {
    private final Expression expression;
    private final Stack<List<EClassifier>> analyzations = new Stack();
    private final Stack<List<Object>> evaluations = new Stack();

    public ExpressionExtensionStatement(int start, int end, int line, int startOffset, int endOffset, Identifier name, Identifier returnType, List<DeclaredParameter> formalParameters, Expression expression, boolean cached, boolean isPrivate) {
        super(start, end, line, startOffset, endOffset, name, returnType, formalParameters, cached, isPrivate);
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public Object evaluateInternal(Object[] parameters, ExecutionContext ctx) {
        List<Object> params = Arrays.asList(parameters);
        if (!this.evaluations.contains(params)) {
            this.evaluations.push(params);
            try {
                Object object = this.evaluateInternal2(parameters, ctx);
                return object;
            }
            finally {
                this.evaluations.pop();
            }
        }
        throw new RuntimeException("Infinite recursion in '" + this.toString() + "'");
    }

    protected Object evaluateInternal2(Object[] parameters, ExecutionContext ctx) {
        ctx = ctx.cloneWithoutVariables();
        ctx = ctx.cloneWithResource(this.file);
        List<String> paramNames = this.getParameterNames();
        int i = 0;
        int x = paramNames.size();
        while (i < x) {
            String name = paramNames.get(i);
            ctx = ctx.cloneWithVariable(new Variable(name, parameters[i]));
            ++i;
        }
        return this.expression.evaluate(ctx);
    }

    @Override
    public void analyzeInternal(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier expressionType = this.expression.analyze(ctx, issues);
        this.createAnalyzeTrace(ctx, new ExpressionAnalyzeTrace(this.getReturnTypeIdentifier() != null ? ctx.getTypeForName(this.getReturnTypeIdentifier().getValue()) : expressionType));
    }

    @Override
    protected EClassifier internalGetReturnType(EClassifier[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        if (this.getReturnTypeIdentifier() != null) {
            return ctx.getTypeForName(this.getReturnTypeIdentifier().getValue());
        }
        if (parameters == null || parameters.length != this.getParameterNames().size()) {
            return null;
        }
        List<EClassifier> params = Arrays.asList(parameters);
        if (!this.analyzations.contains(params)) {
            this.analyzations.push(params);
            try {
                EClassifier eClassifier = this.analyzeInternal(parameters, ctx, issues);
                return eClassifier;
            }
            finally {
                this.analyzations.pop();
            }
        }
        if (this.returnType == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.Type.INTERNAL_ERROR, "Recursive extensions need to have a return type specified!", this));
            return null;
        }
        return ctx.getTypeForName(this.returnType.getValue());
    }

    protected EClassifier analyzeInternal(EClassifier[] parameters, ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ctx = ctx.cloneWithoutVariables();
        ctx = ctx.cloneWithResource(this.file);
        List<String> paramNames = this.getParameterNames();
        int i = 0;
        int x = paramNames.size();
        while (i < x) {
            String name = paramNames.get(i);
            EClassifier t = parameters[i];
            ctx = ctx.cloneWithVariable(new Variable(name, t));
            ++i;
        }
        return this.expression.analyze(ctx, issues);
    }
}

